/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.process;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;

class ProcessStreamDrainerWorker
implements Runnable {
    private final BufferedInputStream reader;
    private final PrintStream redirect;
    private StringBuilder sb;

    ProcessStreamDrainerWorker(InputStream in, PrintStream Redirect2, boolean save) {
        if (in == null) {
            throw new NullPointerException("InputStream argument was null.");
        }
        this.reader = new BufferedInputStream(in);
        this.redirect = Redirect2;
        if (save) {
            this.sb = new StringBuilder();
        }
    }

    @Override
    public void run() {
        if (this.reader == null) {
            return;
        }
        try {
            byte[] buffer = new byte[8192];
            Charset charset = Charset.defaultCharset();
            int count = 0;
            while ((count = this.reader.read(buffer)) != -1) {
                if (this.redirect != null) {
                    this.redirect.write(buffer, 0, count);
                }
                if (this.sb == null) continue;
                this.sb.append(new String(buffer, 0, count, charset));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    String getString() {
        return this.sb == null ? "" : this.sb.toString();
    }
}

