/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.XAResourceForRA;
import com.sun.messaging.jmq.util.JMQXid;
import jakarta.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

abstract class XAResourceForX {
    public static final int CREATED = 0;
    public static final int STARTED = 1;
    public static final int FAILED = 2;
    public static final int INCOMPLETE = 3;
    public static final int COMPLETE = 4;
    public static final int PREPARED = 5;
    public static final boolean turnOffXATracking = Boolean.getBoolean("imq.ra.turnOffXATracking");
    public static final boolean XATracking = !turnOffXATracking;
    ConnectionImpl epConnection;
    int transactionTimeout = 0;
    int id;
    long transactionID = -1L;
    JMQXid jmqXid = null;
    boolean started = false;
    int resourceState = 0;

    XAResourceForX() {
    }

    abstract int prepare(Xid var1, boolean var2) throws XAException;

    final void removeXid(JMQXid jmqXid) {
        if (this.isXATracking()) {
            this.xaTableRemove(jmqXid);
        }
    }

    abstract void checkCommitStatus(Exception var1, int var2, JMQXid var3, boolean var4) throws JMSException, XAException;

    final boolean isXATracking() {
        return this.epConnection.isConnectedToHABroker() && XATracking;
    }

    abstract void xaTablePut(JMQXid var1, Integer var2);

    abstract void xaTableRemove(JMQXid var1);

    void HAOnePhaseCommit(Xid foreignXid, JMQXid jmqXid) throws JMSException, XAException {
        int tstate = 1;
        try {
            this.prepare(foreignXid, true);
            tstate = 2;
            if (this.isXATracking()) {
                this.xaTablePut(jmqXid, XAResourceForRA.XA_PREPARE);
            }
            this.epConnection.getProtocolHandler().commit(0L, 0, jmqXid, true);
        }
        catch (Exception jmse) {
            this.checkCommitStatus(jmse, tstate, jmqXid, true);
        }
        this.removeXid(jmqXid);
    }
}

