/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.ConfigUtils;
import io.helidon.config.spi.ConfigNode;
import io.helidon.config.spi.ConfigParser;
import io.helidon.config.spi.ConfigParserException;
import jakarta.annotation.Priority;
import java.util.Properties;
import java.util.Set;

@Priority(value=200)
public class PropertiesConfigParser
implements ConfigParser {
    public static final String MEDIA_TYPE_TEXT_JAVA_PROPERTIES = "text/x-java-properties";
    public static final int PRIORITY = 200;
    private static final Set<String> SUPPORTED_MEDIA_TYPES = Set.of("text/x-java-properties");

    public Set<String> supportedMediaTypes() {
        return SUPPORTED_MEDIA_TYPES;
    }

    public ConfigNode.ObjectNode parse(ConfigParser.Content content) throws ConfigParserException {
        Properties properties = new Properties();
        try {
            properties.load(content.data());
        }
        catch (Exception e) {
            throw new ConfigParserException("Cannot read from source: " + e.getLocalizedMessage(), (Throwable)e);
        }
        return ConfigUtils.mapToObjectNode(ConfigUtils.propertiesToMap(properties), true);
    }
}

