/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.httptunnel.tunnel.servlet;

import com.sun.messaging.jmq.httptunnel.tunnel.servlet.ServerLink;
import java.util.Vector;

class Connection {
    private Vector pullQ = new Vector();
    private int pullPeriod = -1;
    private ServerLink link = null;
    private boolean inUse = false;
    private long lastRequestTime = 0L;

    Connection(ServerLink link) {
        this.link = link;
        this.lastRequestTime = System.currentTimeMillis();
    }

    public Vector getPullQ() {
        return this.pullQ;
    }

    public int getPullPeriod() {
        return this.pullPeriod;
    }

    public synchronized void setInUse(boolean inUse) {
        this.inUse = inUse;
        if (!inUse) {
            this.lastRequestTime = System.currentTimeMillis();
        }
    }

    public synchronized boolean checkConnectionTimeout(long now) {
        if (this.inUse) {
            return false;
        }
        long timeout = 0L;
        timeout = this.pullPeriod > 0 ? (long)this.pullPeriod * 5L : 60L;
        return now - this.lastRequestTime > (timeout *= 1000L);
    }

    public ServerLink getServerLink() {
        return this.link;
    }

    public void setPullPeriod(int pullPeriod) {
        this.pullPeriod = pullPeriod;
    }
}

