/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.services;

import com.sun.enterprise.admin.servermgmt.services.AppserverServiceType;
import com.sun.enterprise.admin.servermgmt.services.ServiceAdapter;
import com.sun.enterprise.admin.servermgmt.services.ServicesUtils;
import com.sun.enterprise.admin.servermgmt.services.Strings;
import com.sun.enterprise.universal.process.ProcessManager;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.ObjectAnalyzer;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.io.ServerDirs;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class WindowsService
extends ServiceAdapter {
    private static final String SOURCE_WIN32_EXE_FILENAME = "winsw.exe";
    private static final String TARGET_DIR = "bin";
    private static final String TEMPLATE_FILE_NAME = "Domain-service-winsw.xml.template";
    private File sourceWin32Exe;
    private File targetDir;
    private File targetXml;
    private File targetWin32Exe;
    private String xmlFileCopy;

    static boolean apropos() {
        return OS.isWindowsForSure();
    }

    WindowsService(ServerDirs dirs, AppserverServiceType type) {
        super(dirs, type);
        if (!WindowsService.apropos()) {
            throw new IllegalArgumentException(Strings.get("internal.error", "Constructor called but Windows Services are not available."));
        }
    }

    @Override
    public final void createServiceInternal() throws RuntimeException {
        try {
            this.handlePreExisting(this.targetWin32Exe, this.targetXml, this.info.force);
            FileUtils.copy((File)this.sourceWin32Exe, (File)this.targetWin32Exe);
            this.trace("Copied from " + String.valueOf(this.sourceWin32Exe) + " to " + String.valueOf(this.targetWin32Exe));
            this.getTokenMap().put("CREDENTIALS_START", this.getAsadminCredentials("startargument"));
            this.getTokenMap().put("CREDENTIALS_STOP", this.getAsadminCredentials("stopargument"));
            ServicesUtils.tokenReplaceTemplateAtDestination(this.getFinalTokenMap(), this.getTemplateFile(), this.targetXml);
            this.trace("Target XML file written: " + String.valueOf(this.targetXml));
            this.trace("**********   Object Dump  **********\n" + this.toString());
            if (this.uninstall() == 0 && !this.info.dryRun) {
                this.trace(Strings.get("windows.services.uninstall.good"));
            } else {
                this.trace("No preexisting Service with that id and/or name was found");
            }
            this.install();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteServiceInternal() {
        try {
            if (!this.isInstalled()) {
                throw new RuntimeException(Strings.get("not_installed"));
            }
            if (!this.targetWin32Exe.canExecute()) {
                throw new RuntimeException(Strings.get("cant_exec"));
            }
            ProcessManager pm = new ProcessManager(new String[]{this.targetWin32Exe.getAbsolutePath(), "stop"});
            pm.setEcho(false);
            pm.execute();
            pm = new ProcessManager(new String[]{this.targetWin32Exe.getAbsolutePath(), "uninstall"});
            pm.setEcho(false);
            pm.execute();
            this.trace("Uninstalled Windows Service");
            if (!this.targetWin32Exe.delete()) {
                this.targetWin32Exe.deleteOnExit();
            }
            if (!this.targetXml.delete()) {
                this.targetXml.deleteOnExit();
            }
            this.trace("deleted " + String.valueOf(this.targetWin32Exe) + String.valueOf(this.targetXml));
            this.trace(this.toString());
        }
        catch (ProcessManagerException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public final String getSuccessMessage() {
        if (this.info.dryRun) {
            return Strings.get("dryrun");
        }
        return Strings.get("WindowsServiceCreated", this.info.serviceName, this.getTokenMap().get("DISPLAY_NAME"), this.getServerDirs().getServerDir(), this.targetXml, this.targetWin32Exe);
    }

    @Override
    public final void writeReadmeFile(String msg) {
        File f = new File(this.getServerDirs().getServerDir(), "PlatformServices.log");
        if (StringUtils.ok((String)this.xmlFileCopy)) {
            msg = (String)msg + this.xmlFileCopy;
        }
        ServicesUtils.appendTextToFile(f, (String)msg);
    }

    public String toString() {
        return ObjectAnalyzer.toString((Object)this);
    }

    @Override
    public final String getLocationArgsStart() {
        if (this.isDomain()) {
            return this.makeStartArg("--domaindir") + this.makeStartArg(this.quote(this.getServerDirs().getServerParentDir().getPath()));
        }
        return this.makeStartArg("--nodedir") + this.makeStartArg(this.quote(this.getServerDirs().getServerGrandParentDir().getPath().replace('\\', '/'))) + this.makeStartArg("--node") + this.makeStartArg(this.quote(this.getServerDirs().getServerParentDir().getName()));
    }

    @Override
    public final String getLocationArgsStop() {
        if (this.isDomain()) {
            return this.makeStopArg("--domaindir") + this.makeStopArg(this.quote(this.getServerDirs().getServerParentDir().getPath()));
        }
        return this.makeStopArg("--nodedir") + this.makeStopArg(this.quote(this.getServerDirs().getServerGrandParentDir().getPath().replace('\\', '/'))) + this.makeStopArg("--node") + this.makeStopArg(this.quote(this.getServerDirs().getServerParentDir().getName()));
    }

    private String quote(String s) {
        return StringUtils.quotePathIfNecessary((String)s);
    }

    @Override
    public final void initializeInternal() {
        try {
            this.getTokenMap().put("DISPLAY_NAME", this.info.serverDirs.getServerName() + " GlassFish Server");
            this.setTemplateFile(TEMPLATE_FILE_NAME);
            this.setSourceWin32Exe();
            this.targetDir = new File(this.getServerDirs().getServerDir(), TARGET_DIR);
            if (!this.targetDir.isDirectory() && !this.targetDir.mkdirs()) {
                throw new RuntimeException(Strings.get("noTargetDir", this.targetDir));
            }
            this.targetWin32Exe = new File(this.targetDir, this.info.serviceName + "Service.exe");
            this.targetXml = new File(this.targetDir, this.info.serviceName + "Service.xml");
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private boolean isInstalled() {
        if (this.targetDir == null || this.targetWin32Exe == null || this.targetXml == null) {
            throw new RuntimeException(Strings.get("internal.error", "call to isInstall() before initializeInternal()"));
        }
        return this.targetWin32Exe.isFile() && this.targetXml.isFile();
    }

    private void setSourceWin32Exe() throws IOException {
        this.sourceWin32Exe = new File(this.info.libDir, SOURCE_WIN32_EXE_FILENAME);
        if (!this.sourceWin32Exe.isFile()) {
            InputStream in = null;
            FileOutputStream out = null;
            try {
                in = WindowsService.class.getResourceAsStream("/lib/winsw.exe");
                out = new FileOutputStream(this.sourceWin32Exe);
                WindowsService.copyStream(in, out);
                this.trace("Copied from inside the jar to " + String.valueOf(this.sourceWin32Exe));
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
        this.trace("Source executable: " + String.valueOf(this.sourceWin32Exe));
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[16384];
        while ((len = in.read(buf)) >= 0) {
            out.write(buf, 0, len);
        }
    }

    private String getAsadminCredentials(String elem) {
        if (this.info.passwordFile == null) {
            return " ";
        }
        String user = this.info.appserverUser;
        String begin = "<" + elem + ">";
        String end = "</" + elem + ">\n";
        StringBuilder sb = new StringBuilder();
        if (user != null) {
            sb.append("  ").append(begin).append("--user").append(end);
            sb.append("  ").append(begin).append(user).append(end);
        }
        sb.append("  ").append(begin).append("--passwordfile").append(end);
        sb.append("  ").append(begin).append(this.info.passwordFile.getPath()).append(end);
        sb.append("  ");
        return sb.toString();
    }

    private int uninstall() throws ProcessManagerException {
        if (this.info.dryRun || !this.targetWin32Exe.canExecute()) {
            return 0;
        }
        ProcessManager mgr = new ProcessManager(new String[]{this.targetWin32Exe.getPath(), "uninstall"});
        mgr.setEcho(false);
        int exitValue = mgr.execute();
        this.trace("Uninstall STDERR: " + mgr.getStderr());
        this.trace("Uninstall STDOUT: " + mgr.getStdout());
        return exitValue;
    }

    private void install() throws ProcessManagerException {
        if (this.info.dryRun) {
            try {
                this.xmlFileCopy = Strings.get("xmlfiledump") + FileUtils.readSmallFile((File)this.targetXml, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!this.targetWin32Exe.delete()) {
                this.dryRun("Dry Run error: delete failed for targetWin32Exe " + String.valueOf(this.targetWin32Exe));
            }
            if (!this.targetXml.delete()) {
                this.dryRun("Dry Run error: delete failed for targetXml " + String.valueOf(this.targetXml));
            }
        } else {
            ProcessManager mgr = new ProcessManager(new String[]{this.targetWin32Exe.getPath(), "install"});
            mgr.setEcho(false);
            int ret = mgr.execute();
            if (ret != 0) {
                throw new RuntimeException(Strings.get("windows.services.install.bad", "" + ret, mgr.getStdout(), mgr.getStderr()));
            }
            this.trace("Install STDERR: " + mgr.getStderr());
            this.trace("Install STDOUT: " + mgr.getStdout());
        }
    }

    private void handlePreExisting(File targetWin32Exe, File targetXml, boolean force) {
        if ((targetWin32Exe.exists() || targetXml.exists()) && force) {
            if (!targetWin32Exe.delete()) {
                this.trace("HandlePreExisting error: could not delete targetWin32Exe.");
            }
            if (!targetXml.delete()) {
                this.trace("HandlePreExisting error: could not delete targetXml.");
            }
            if (targetWin32Exe.exists() || targetXml.exists()) {
                throw new RuntimeException(Strings.get("services.alreadyCreated", new File(this.targetDir, this.getServerDirs().getServerName() + "Service").toString() + ".*", "del"));
            }
        }
    }

    private String makeStartArg(String s) {
        return "  <startargument>" + s + "</startargument>\n";
    }

    private String makeStopArg(String s) {
        return "  <stopargument>" + s + "</stopargument>\n";
    }
}

