/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.asm;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import org.glassfish.rmic.tools.asm.CatchData;
import org.glassfish.rmic.tools.asm.ConstantPool;
import org.glassfish.rmic.tools.asm.Cover;
import org.glassfish.rmic.tools.asm.Instruction;
import org.glassfish.rmic.tools.asm.Label;
import org.glassfish.rmic.tools.asm.LocalVariable;
import org.glassfish.rmic.tools.asm.LocalVariableTable;
import org.glassfish.rmic.tools.asm.SwitchData;
import org.glassfish.rmic.tools.asm.TryData;
import org.glassfish.rmic.tools.java.ClassDefinition;
import org.glassfish.rmic.tools.java.CompilerError;
import org.glassfish.rmic.tools.java.Constants;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.MemberDefinition;
import org.glassfish.rmic.tools.java.Type;
import org.glassfish.rmic.tools.javac.SourceClass;

public final class Assembler
implements Constants {
    static final int NOTREACHED = 0;
    static final int REACHED = 1;
    static final int NEEDED = 2;
    Label first = new Label();
    Instruction last = this.first;
    int maxdepth;
    int maxvar;
    int maxpc;
    static Vector<String> SourceClassList = new Vector();
    static Vector<String> TmpCovTable = new Vector();
    static int[] JcovClassCountArray = new int[9];
    static String JcovMagicLine = "JCOV-DATA-FILE-VERSION: 2.0";
    static String JcovClassLine = "CLASS: ";
    static String JcovSrcfileLine = "SRCFILE: ";
    static String JcovTimestampLine = "TIMESTAMP: ";
    static String JcovDataLine = "DATA: ";
    static String JcovHeadingLine = "#kind\tcount";
    static int[] arrayModifiers = new int[]{1, 2, 4, 1024, 16, 512};
    static int[] arrayModifiersOpc = new int[]{121, 120, 122, 130, 128, 114};

    public void add(Instruction inst) {
        if (inst != null) {
            this.last.next = inst;
            this.last = inst;
        }
    }

    public void add(long where, int opc) {
        this.add(new Instruction(where, opc, null));
    }

    public void add(long where, int opc, Object obj) {
        this.add(new Instruction(where, opc, obj));
    }

    public void add(long where, int opc, Object obj, boolean flagCondInverted) {
        this.add(new Instruction(where, opc, obj, flagCondInverted));
    }

    public void add(boolean flagNoCovered, long where, int opc, Object obj) {
        this.add(new Instruction(flagNoCovered, where, opc, obj));
    }

    public void add(long where, int opc, boolean flagNoCovered) {
        this.add(new Instruction(where, opc, flagNoCovered));
    }

    void optimize(Environment env, Label lbl) {
        lbl.pc = 1;
        Instruction inst = lbl.next;
        while (inst != null) {
            switch (inst.pc) {
                case 0: {
                    inst.optimize(env);
                    inst.pc = 1;
                    break;
                }
                case 1: {
                    return;
                }
            }
            switch (inst.opc) {
                case -2: 
                case -1: {
                    if (inst.pc != 1) break;
                    inst.pc = 0;
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    this.optimize(env, (Label)inst.value);
                    break;
                }
                case 167: {
                    this.optimize(env, (Label)inst.value);
                    return;
                }
                case 168: {
                    this.optimize(env, (Label)inst.value);
                    break;
                }
                case 169: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    return;
                }
                case 170: 
                case 171: {
                    SwitchData sw = (SwitchData)inst.value;
                    this.optimize(env, sw.defaultLabel);
                    Enumeration<Object> e = sw.tab.elements();
                    while (e.hasMoreElements()) {
                        this.optimize(env, (Label)e.nextElement());
                    }
                    return;
                }
                case -3: {
                    TryData td = (TryData)inst.value;
                    td.getEndLabel().pc = 2;
                    Enumeration<Object> e = td.catches.elements();
                    while (e.hasMoreElements()) {
                        CatchData cd = (CatchData)e.nextElement();
                        this.optimize(env, cd.getLabel());
                    }
                    break;
                }
            }
            inst = inst.next;
        }
    }

    boolean eliminate() {
        boolean change = false;
        Instruction prev = this.first;
        Instruction inst = this.first.next;
        while (inst != null) {
            if (inst.pc != 0) {
                prev.next = inst;
                prev = inst;
                inst.pc = 0;
            } else {
                change = true;
            }
            inst = inst.next;
        }
        this.first.pc = 0;
        prev.next = null;
        return change;
    }

    public void optimize(Environment env) {
        do {
            this.optimize(env, this.first);
        } while (this.eliminate() && env.opt());
    }

    public void collect(Environment env, MemberDefinition field, ConstantPool tab) {
        Vector<MemberDefinition> v;
        if (field != null && env.debug_vars() && (v = field.getArguments()) != null) {
            Enumeration<MemberDefinition> e = v.elements();
            while (e.hasMoreElements()) {
                MemberDefinition f = e.nextElement();
                tab.put(f.getName().toString());
                tab.put(f.getType().getTypeSignature());
            }
        }
        Instruction inst = this.first;
        while (inst != null) {
            inst.collect(tab);
            inst = inst.next;
        }
    }

    void balance(Label lbl, int depth) {
        Instruction inst = lbl;
        while (inst != null) {
            if ((depth += inst.balance()) < 0) {
                throw new CompilerError("stack under flow: " + inst.toString() + " = " + depth);
            }
            if (depth > this.maxdepth) {
                this.maxdepth = depth;
            }
            switch (inst.opc) {
                case -1: {
                    lbl = inst;
                    if (inst.pc == 1) {
                        if (lbl.depth != depth) {
                            throw new CompilerError("stack depth error " + depth + "/" + lbl.depth + ": " + inst.toString());
                        }
                        return;
                    }
                    lbl.pc = 1;
                    lbl.depth = depth;
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    this.balance((Label)inst.value, depth);
                    break;
                }
                case 167: {
                    this.balance((Label)inst.value, depth);
                    return;
                }
                case 168: {
                    this.balance((Label)inst.value, depth + 1);
                    break;
                }
                case 169: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    return;
                }
                case 21: 
                case 23: 
                case 25: 
                case 54: 
                case 56: 
                case 58: {
                    int v = (inst.value instanceof Number ? ((Number)inst.value).intValue() : ((LocalVariable)inst.value).slot) + 1;
                    if (v <= this.maxvar) break;
                    this.maxvar = v;
                    break;
                }
                case 22: 
                case 24: 
                case 55: 
                case 57: {
                    int v = (inst.value instanceof Number ? ((Number)inst.value).intValue() : ((LocalVariable)inst.value).slot) + 2;
                    if (v <= this.maxvar) break;
                    this.maxvar = v;
                    break;
                }
                case 132: {
                    int v = ((int[])inst.value)[0] + 1;
                    if (v <= this.maxvar) break;
                    this.maxvar = v + 1;
                    break;
                }
                case 170: 
                case 171: {
                    SwitchData sw = (SwitchData)inst.value;
                    this.balance(sw.defaultLabel, depth);
                    Enumeration<Object> e = sw.tab.elements();
                    while (e.hasMoreElements()) {
                        this.balance((Label)e.nextElement(), depth);
                    }
                    return;
                }
                case -3: {
                    TryData td = (TryData)inst.value;
                    Enumeration<Object> e = td.catches.elements();
                    while (e.hasMoreElements()) {
                        CatchData cd = e.nextElement();
                        this.balance(cd.getLabel(), depth + 1);
                    }
                    break;
                }
            }
            inst = inst.next;
        }
    }

    public void write(Environment env, DataOutputStream out, MemberDefinition field, ConstantPool tab) throws IOException {
        if (field != null && field.getArguments() != null) {
            int sum = 0;
            Vector<MemberDefinition> v = field.getArguments();
            Enumeration<MemberDefinition> e = v.elements();
            while (e.hasMoreElements()) {
                MemberDefinition f = e.nextElement();
                sum += f.getType().stackSize();
            }
            this.maxvar = sum;
        }
        try {
            this.balance(this.first, 0);
        }
        catch (CompilerError e) {
            System.out.println("ERROR: " + e);
            this.listing(System.out);
            throw e;
        }
        int pc = 0;
        int nexceptions = 0;
        Instruction inst = this.first;
        while (inst != null) {
            inst.pc = pc;
            int sz = inst.size(tab);
            if (pc < 65536 && pc + sz >= 65536) {
                env.error(inst.where, "warn.method.too.long");
            }
            pc += sz;
            if (inst.opc == -3) {
                nexceptions += ((TryData)inst.value).catches.size();
            }
            inst = inst.next;
        }
        out.writeShort(this.maxdepth);
        out.writeShort(this.maxvar);
        this.maxpc = pc;
        out.writeInt(this.maxpc);
        inst = this.first.next;
        while (inst != null) {
            inst.write(out, tab);
            inst = inst.next;
        }
        out.writeShort(nexceptions);
        if (nexceptions > 0) {
            this.writeExceptions(env, out, tab, this.first, this.last);
        }
    }

    void writeExceptions(Environment env, DataOutputStream out, ConstantPool tab, Instruction first, Instruction last) throws IOException {
        Instruction inst = first;
        while (inst != last.next) {
            if (inst.opc == -3) {
                TryData td = (TryData)inst.value;
                this.writeExceptions(env, out, tab, inst.next, td.getEndLabel());
                Enumeration<CatchData> e = td.catches.elements();
                while (e.hasMoreElements()) {
                    CatchData cd = e.nextElement();
                    out.writeShort(inst.pc);
                    out.writeShort(td.getEndLabel().pc);
                    out.writeShort(cd.getLabel().pc);
                    if (cd.getType() != null) {
                        out.writeShort(tab.index(cd.getType()));
                        continue;
                    }
                    out.writeShort(0);
                }
                inst = td.getEndLabel();
            }
            inst = inst.next;
        }
    }

    public void writeCoverageTable(Environment env, ClassDefinition c, DataOutputStream out, ConstantPool tab, long whereField) throws IOException {
        Vector<Cover> TableLot = new Vector<Cover>();
        boolean begseg = false;
        boolean begmeth = false;
        long whereClass = ((SourceClass)c).getWhere();
        Vector<Long> whereTry = new Vector<Long>();
        boolean numberTry = false;
        int count = 0;
        Instruction inst = this.first;
        while (inst != null) {
            Enumeration<Integer> e;
            long n = inst.where >> 32;
            if (n > 0L && inst.opc != -1) {
                if (!begmeth) {
                    if (whereClass == inst.where) {
                        TableLot.addElement(new Cover(2, whereField, inst.pc));
                    } else {
                        TableLot.addElement(new Cover(1, whereField, inst.pc));
                    }
                    ++count;
                    begmeth = true;
                }
                if (!begseg && !inst.flagNoCovered) {
                    boolean findTry = false;
                    e = whereTry.elements();
                    while (e.hasMoreElements()) {
                        if ((Long)((Object)e.nextElement()) != inst.where) continue;
                        findTry = true;
                        break;
                    }
                    if (!findTry) {
                        TableLot.addElement(new Cover(3, inst.where, inst.pc));
                        ++count;
                        begseg = true;
                    }
                }
            }
            switch (inst.opc) {
                case -1: {
                    begseg = false;
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    if (inst.flagCondInverted) {
                        TableLot.addElement(new Cover(7, inst.where, inst.pc));
                        TableLot.addElement(new Cover(8, inst.where, inst.pc));
                    } else {
                        TableLot.addElement(new Cover(8, inst.where, inst.pc));
                        TableLot.addElement(new Cover(7, inst.where, inst.pc));
                    }
                    count += 2;
                    begseg = false;
                    break;
                }
                case 167: {
                    begseg = false;
                    break;
                }
                case 169: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    break;
                }
                case -3: {
                    whereTry.addElement(inst.where);
                    begseg = false;
                    break;
                }
                case 170: {
                    SwitchData sw = (SwitchData)inst.value;
                    for (int i = sw.minValue; i <= sw.maxValue; ++i) {
                        TableLot.addElement(new Cover(5, sw.whereCase(i), inst.pc));
                        ++count;
                    }
                    if (!sw.getDefault()) {
                        TableLot.addElement(new Cover(6, inst.where, inst.pc));
                        ++count;
                    } else {
                        TableLot.addElement(new Cover(5, sw.whereCase("default"), inst.pc));
                        ++count;
                    }
                    begseg = false;
                    break;
                }
                case 171: {
                    SwitchData sw = (SwitchData)inst.value;
                    e = sw.sortedKeys();
                    while (e.hasMoreElements()) {
                        Integer v = e.nextElement();
                        TableLot.addElement(new Cover(5, sw.whereCase(v), inst.pc));
                        ++count;
                    }
                    if (!sw.getDefault()) {
                        TableLot.addElement(new Cover(6, inst.where, inst.pc));
                        ++count;
                    } else {
                        TableLot.addElement(new Cover(5, sw.whereCase("default"), inst.pc));
                        ++count;
                    }
                    begseg = false;
                    break;
                }
            }
            inst = inst.next;
        }
        out.writeShort(count);
        for (int i = 0; i < count; ++i) {
            Cover Lot = (Cover)TableLot.elementAt(i);
            long ln = Lot.Addr >> 32;
            long pos = Lot.Addr << 32 >> 32;
            out.writeShort(Lot.NumCommand);
            out.writeShort(Lot.Type);
            out.writeInt((int)ln);
            out.writeInt((int)pos);
            if (Lot.Type == 5 && Lot.Addr == 0L) continue;
            int n = Lot.Type;
            JcovClassCountArray[n] = JcovClassCountArray[n] + 1;
        }
    }

    public void addNativeToJcovTab(Environment env, ClassDefinition c) {
        JcovClassCountArray[1] = JcovClassCountArray[1] + 1;
    }

    private String createClassJcovElement(Environment env, ClassDefinition c) {
        String SourceClass2 = Type.mangleInnerType(c.getClassDeclaration().getName()).toString();
        SourceClassList.addElement(SourceClass2);
        String ConvSourceClass = SourceClass2.replace('.', '/');
        String classJcovLine = JcovClassLine + ConvSourceClass;
        classJcovLine = classJcovLine + " [";
        String blank = "";
        for (int i = 0; i < arrayModifiers.length; ++i) {
            if ((c.getModifiers() & arrayModifiers[i]) == 0) continue;
            classJcovLine = classJcovLine + blank + opNames[arrayModifiersOpc[i]];
            blank = " ";
        }
        classJcovLine = classJcovLine + "]";
        return classJcovLine;
    }

    public void GenVecJCov(Environment env, ClassDefinition c, long Time) {
        String SourceFile = ((SourceClass)c).getAbsoluteName();
        TmpCovTable.addElement(this.createClassJcovElement(env, c));
        TmpCovTable.addElement(JcovSrcfileLine + SourceFile);
        TmpCovTable.addElement(JcovTimestampLine + Time);
        TmpCovTable.addElement(JcovDataLine + "A");
        TmpCovTable.addElement(JcovHeadingLine);
        for (int i = 1; i <= 8; ++i) {
            if (JcovClassCountArray[i] == 0) continue;
            TmpCovTable.addElement(new String(i + "\t" + JcovClassCountArray[i]));
            Assembler.JcovClassCountArray[i] = 0;
        }
    }

    public void GenJCov(Environment env) {
        try {
            File outFile = env.getcovFile();
            if (outFile.exists()) {
                DataInputStream JCovd = new DataInputStream(new BufferedInputStream(new FileInputStream(outFile)));
                String CurrLine = null;
                boolean first = true;
                CurrLine = JCovd.readLine();
                if (CurrLine != null && CurrLine.startsWith(JcovMagicLine)) {
                    while ((CurrLine = JCovd.readLine()) != null) {
                        if (CurrLine.startsWith(JcovClassLine)) {
                            first = true;
                            Enumeration<String> e = SourceClassList.elements();
                            while (e.hasMoreElements()) {
                                String Class2;
                                String clsName = CurrLine.substring(JcovClassLine.length());
                                int idx = clsName.indexOf(32);
                                if (idx != -1) {
                                    clsName = clsName.substring(0, idx);
                                }
                                if ((Class2 = e.nextElement()).compareTo(clsName) != 0) continue;
                                first = false;
                                break;
                            }
                        }
                        if (!first) continue;
                        TmpCovTable.addElement(CurrLine);
                    }
                }
                JCovd.close();
            }
            PrintStream CovFile = new PrintStream(new DataOutputStream(new FileOutputStream(outFile)));
            CovFile.println(JcovMagicLine);
            Enumeration<String> e = TmpCovTable.elements();
            while (e.hasMoreElements()) {
                CovFile.println(e.nextElement());
            }
            CovFile.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("ERROR: " + e);
        }
        catch (IOException e) {
            System.out.println("ERROR: " + e);
        }
    }

    public void writeLineNumberTable(Environment env, DataOutputStream out, ConstantPool tab) throws IOException {
        long n;
        long ln = -1L;
        int count = 0;
        Instruction inst = this.first;
        while (inst != null) {
            n = inst.where >> 32;
            if (n > 0L && ln != n) {
                ln = n;
                ++count;
            }
            inst = inst.next;
        }
        ln = -1L;
        out.writeShort(count);
        inst = this.first;
        while (inst != null) {
            n = inst.where >> 32;
            if (n > 0L && ln != n) {
                ln = n;
                out.writeShort(inst.pc);
                out.writeShort((int)ln);
            }
            inst = inst.next;
        }
    }

    void flowFields(Environment env, Label lbl, MemberDefinition[] locals) {
        if (lbl.locals != null) {
            MemberDefinition[] f = lbl.locals;
            for (int i = 0; i < this.maxvar; ++i) {
                if (f[i] == locals[i]) continue;
                f[i] = null;
            }
            return;
        }
        lbl.locals = new MemberDefinition[this.maxvar];
        System.arraycopy(locals, 0, lbl.locals, 0, this.maxvar);
        MemberDefinition[] newlocals = new MemberDefinition[this.maxvar];
        System.arraycopy(locals, 0, newlocals, 0, this.maxvar);
        locals = newlocals;
        Instruction inst = lbl.next;
        while (inst != null) {
            switch (inst.opc) {
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    if (!(inst.value instanceof LocalVariable)) break;
                    LocalVariable v = (LocalVariable)inst.value;
                    locals[v.slot] = v.field;
                    break;
                }
                case -1: {
                    this.flowFields(env, (Label)inst, locals);
                    return;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 168: 
                case 198: 
                case 199: {
                    this.flowFields(env, (Label)inst.value, locals);
                    break;
                }
                case 167: {
                    this.flowFields(env, (Label)inst.value, locals);
                    return;
                }
                case 169: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    return;
                }
                case 170: 
                case 171: {
                    SwitchData sw = (SwitchData)inst.value;
                    this.flowFields(env, sw.defaultLabel, locals);
                    Enumeration<Object> e = sw.tab.elements();
                    while (e.hasMoreElements()) {
                        this.flowFields(env, (Label)e.nextElement(), locals);
                    }
                    return;
                }
                case -3: {
                    Vector<CatchData> catches = ((TryData)inst.value).catches;
                    Enumeration<Object> e = catches.elements();
                    while (e.hasMoreElements()) {
                        CatchData cd = e.nextElement();
                        this.flowFields(env, cd.getLabel(), locals);
                    }
                    break;
                }
            }
            inst = inst.next;
        }
    }

    public void writeLocalVariableTable(Environment env, MemberDefinition field, DataOutputStream out, ConstantPool tab) throws IOException {
        MemberDefinition[] locals = new MemberDefinition[this.maxvar];
        int i = 0;
        if (field != null && field.getArguments() != null) {
            int reg = 0;
            Vector<MemberDefinition> v = field.getArguments();
            Enumeration<MemberDefinition> e = v.elements();
            while (e.hasMoreElements()) {
                MemberDefinition f;
                locals[reg] = f = e.nextElement();
                reg += f.getType().stackSize();
            }
        }
        this.flowFields(env, this.first, locals);
        LocalVariableTable lvtab = new LocalVariableTable();
        for (i = 0; i < this.maxvar; ++i) {
            locals[i] = null;
        }
        if (field != null && field.getArguments() != null) {
            int reg = 0;
            Vector<MemberDefinition> v = field.getArguments();
            Enumeration<MemberDefinition> e = v.elements();
            while (e.hasMoreElements()) {
                MemberDefinition f;
                locals[reg] = f = e.nextElement();
                lvtab.define(f, reg, 0, this.maxpc);
                reg += f.getType().stackSize();
            }
        }
        int[] pcs = new int[this.maxvar];
        Instruction inst = this.first;
        while (inst != null) {
            switch (inst.opc) {
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    int pc;
                    if (!(inst.value instanceof LocalVariable)) break;
                    LocalVariable v = (LocalVariable)inst.value;
                    int n = pc = inst.next != null ? inst.next.pc : inst.pc;
                    if (locals[v.slot] != null) {
                        lvtab.define(locals[v.slot], v.slot, pcs[v.slot], pc);
                    }
                    pcs[v.slot] = pc;
                    locals[v.slot] = v.field;
                    break;
                }
                case -1: {
                    for (i = 0; i < this.maxvar; ++i) {
                        if (locals[i] == null) continue;
                        lvtab.define(locals[i], i, pcs[i], inst.pc);
                    }
                    int pc = inst.pc;
                    MemberDefinition[] labelLocals = inst.locals;
                    if (labelLocals == null) {
                        for (i = 0; i < this.maxvar; ++i) {
                            locals[i] = null;
                        }
                    } else {
                        System.arraycopy(labelLocals, 0, locals, 0, this.maxvar);
                    }
                    for (i = 0; i < this.maxvar; ++i) {
                        pcs[i] = pc;
                    }
                    break;
                }
            }
            inst = inst.next;
        }
        for (i = 0; i < this.maxvar; ++i) {
            if (locals[i] == null) continue;
            lvtab.define(locals[i], i, pcs[i], this.maxpc);
        }
        lvtab.write(env, out, tab);
    }

    public boolean empty() {
        return this.first == this.last;
    }

    public void listing(PrintStream out) {
        out.println("-- listing --");
        Instruction inst = this.first;
        while (inst != null) {
            out.println(((Instruction)inst).toString());
            inst = inst.next;
        }
    }
}

