/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.shared.common.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class ArrayUtil {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public static <T> T[] copy(T[] TArray) {
        return TArray == null ? null : Arrays.copyOf(TArray, TArray.length);
    }

    public static boolean[] copy(boolean[] blArray) {
        return blArray == null ? null : (boolean[])blArray.clone();
    }

    public static byte[] copy(byte[] byArray) {
        return byArray == null ? null : (byte[])byArray.clone();
    }

    public static int[] copy(int[] nArray) {
        return nArray == null ? null : (int[])nArray.clone();
    }

    public static long[] copy(long[] lArray) {
        return lArray == null ? null : (long[])lArray.clone();
    }

    public static int[][] copy2(int[][] nArray) {
        if (nArray == null) {
            return null;
        }
        int[][] nArrayArray = new int[nArray.length][];
        for (int i = 0; i < nArray.length; ++i) {
            nArrayArray[i] = ArrayUtil.copy(nArray[i]);
        }
        return nArrayArray;
    }

    @SafeVarargs
    public static <T> List<T> asReadOnlyList(T ... TArray) {
        if (TArray == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(TArray));
    }

    public static void writeArrayLength(ObjectOutput objectOutput, Object[] objectArray) throws IOException {
        objectOutput.writeInt(objectArray.length);
    }

    public static void writeArrayItems(ObjectOutput objectOutput, Object[] objectArray) throws IOException {
        if (objectArray == null) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            objectOutput.writeObject(objectArray[i]);
        }
    }

    public static void writeArray(ObjectOutput objectOutput, Object[] objectArray) throws IOException {
        if (objectArray == null) {
            objectOutput.writeInt(0);
            return;
        }
        objectOutput.writeInt(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            objectOutput.writeObject(objectArray[i]);
        }
    }

    public static void readArrayItems(ObjectInput objectInput, Object[] objectArray) throws IOException, ClassNotFoundException {
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = objectInput.readObject();
        }
    }

    public static int readArrayLength(ObjectInput objectInput) throws IOException {
        return objectInput.readInt();
    }

    public static Object[] readObjectArray(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        if (n == 0) {
            return null;
        }
        Object[] objectArray = new Object[n];
        ArrayUtil.readArrayItems(objectInput, objectArray);
        return objectArray;
    }

    public static void writeIntArray(ObjectOutput objectOutput, int[] nArray) throws IOException {
        if (nArray == null) {
            objectOutput.writeInt(0);
        } else {
            objectOutput.writeInt(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                objectOutput.writeInt(nArray[i]);
            }
        }
    }

    public static int[] readIntArray(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = objectInput.readInt();
        }
        return nArray;
    }

    public static void writeInts(ObjectOutput objectOutput, int[][] nArray) throws IOException {
        if (nArray == null) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            int n = nArray.length;
            objectOutput.writeInt(n);
            for (int i = 0; i < n; ++i) {
                ArrayUtil.writeIntArray(objectOutput, nArray[i]);
            }
        }
    }

    public static int[][] readInts(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int[][] nArrayArray = null;
        if (objectInput.readBoolean()) {
            int n = objectInput.readInt();
            nArrayArray = new int[n][];
            for (int i = 0; i < n; ++i) {
                nArrayArray[i] = ArrayUtil.readIntArray(objectInput);
            }
        }
        return nArrayArray;
    }

    public static String toString(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append("[").append(nArray[i]).append("],");
        }
        return stringBuffer.toString();
    }

    public static void writeLongArray(ObjectOutput objectOutput, long[] lArray) throws IOException {
        if (lArray == null) {
            objectOutput.writeInt(0);
        } else {
            objectOutput.writeInt(lArray.length);
            for (int i = 0; i < lArray.length; ++i) {
                objectOutput.writeLong(lArray[i]);
            }
        }
    }

    public static long[] readLongArray(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = objectInput.readLong();
        }
        return lArray;
    }

    public static String[] readStringArray(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object[] objectArray = null;
        int n = ArrayUtil.readArrayLength(objectInput);
        if (n > 0) {
            objectArray = new String[n];
            ArrayUtil.readArrayItems(objectInput, objectArray);
        }
        return objectArray;
    }

    public static void writeBooleanArray(ObjectOutput objectOutput, boolean[] blArray) throws IOException {
        if (blArray == null) {
            objectOutput.writeInt(0);
        } else {
            objectOutput.writeInt(blArray.length);
            for (int i = 0; i < blArray.length; ++i) {
                objectOutput.writeBoolean(blArray[i]);
            }
        }
    }

    public static boolean[] readBooleanArray(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = objectInput.readBoolean();
        }
        return blArray;
    }
}

