/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policyconv;

import com.sun.xml.ws.security.impl.policyconv.EncryptionTargetCreator;
import com.sun.xml.ws.security.impl.policyconv.SecurityPolicyUtil;
import com.sun.xml.ws.security.policy.AlgorithmSuite;
import com.sun.xml.ws.security.policy.EncryptedElements;
import com.sun.xml.ws.security.policy.EncryptedParts;
import com.sun.xml.ws.security.policy.Header;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionTarget;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class EncryptionAssertionProcessor {
    private boolean bodyEncrypted = false;
    private boolean encryptAttachments = false;
    private HashSet<Header> encryptedParts = new HashSet();
    private EncryptionTargetCreator etCreator = null;

    public EncryptionAssertionProcessor(AlgorithmSuite algorithmSuite, boolean enforce) {
        this.etCreator = new EncryptionTargetCreator(algorithmSuite, enforce);
    }

    public EncryptionTargetCreator getTargetCreator() {
        return this.etCreator;
    }

    public void process(EncryptedParts encryptParts, EncryptionPolicy.FeatureBinding binding) {
        EncryptionTarget target;
        if (SecurityPolicyUtil.isEncryptedPartsEmpty(encryptParts) && !this.bodyEncrypted) {
            EncryptionTarget target2 = this.etCreator.newQNameEncryptionTarget(EncryptionTarget.BODY_QNAME);
            target2.setContentOnly(true);
            binding.addTargetBinding(target2);
            this.bodyEncrypted = true;
        }
        Iterator tv = encryptParts.getTargets();
        while (tv.hasNext()) {
            Header ht = (Header)tv.next();
            if (this.seenEncryptedParts(ht)) continue;
            EncryptionTarget target3 = this.etCreator.newQNameEncryptionTarget(new QName(ht.getURI(), ht.getLocalName()));
            target3.isSOAPHeadersOnly(true);
            binding.addTargetBinding(target3);
        }
        if (encryptParts.hasBody() && !this.bodyEncrypted) {
            target = this.etCreator.newQNameEncryptionTarget(EncryptionTarget.BODY_QNAME);
            target.setContentOnly(true);
            binding.addTargetBinding(target);
            this.bodyEncrypted = true;
        }
        if (encryptParts.hasAttachments() && !this.encryptAttachments) {
            target = this.etCreator.newURIEncryptionTarget("cid:*");
            target.setContentOnly(true);
            this.etCreator.addAttachmentTransform(target, "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Ciphertext-Transform");
            binding.addTargetBinding(target);
            this.encryptAttachments = true;
        }
    }

    public void process(EncryptedElements encryptedElements, EncryptionPolicy.FeatureBinding binding) {
        Iterator<String> eeItr = encryptedElements.getTargets();
        while (eeItr.hasNext()) {
            String xpathTarget = eeItr.next();
            EncryptionTarget target = this.etCreator.newXpathEncryptionTarget(xpathTarget);
            binding.addTargetBinding(target);
        }
    }

    private boolean seenEncryptedParts(Header header) {
        if (this.encryptedParts.contains(header)) {
            return true;
        }
        this.encryptedParts.add(header);
        return false;
    }

    public void process(QName targetName, EncryptionPolicy.FeatureBinding binding) {
        EncryptionTarget target = this.etCreator.newQNameEncryptionTarget(targetName);
        binding.addTargetBinding(target);
    }
}

