/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.payload;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.glassfish.admin.payload.PayloadImpl;
import org.glassfish.api.admin.Payload;

class ZipPayloadImpl
extends PayloadImpl {
    private static final String PAYLOAD_IMPL_CONTENT_TYPE = "application/zip";

    ZipPayloadImpl() {
    }

    private static class Extra {
        private static final String CONTENT_TYPE_NAME = "Content-Type";
        private String contentType;
        private Properties props;

        private Extra(byte[] extra) {
            try {
                this.props = new Properties();
                ByteArrayInputStream bais = new ByteArrayInputStream(extra);
                this.props.load(bais);
                this.contentType = this.props.getProperty(CONTENT_TYPE_NAME);
                this.props.remove(CONTENT_TYPE_NAME);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        private Extra(String contentType, Properties props) {
            this.contentType = contentType;
            this.props = props;
        }

        private byte[] toBytes() {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Properties fullProps = new Properties();
            if (this.props != null) {
                fullProps.putAll((Map<?, ?>)this.props);
            }
            fullProps.setProperty(CONTENT_TYPE_NAME, this.contentType);
            try {
                fullProps.store(baos, null);
                return baos.toByteArray();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        private String getContentType() {
            return this.contentType;
        }

        private Properties getProperties() {
            return this.props;
        }
    }

    static class Part
    extends PayloadImpl.Part {
        private final Inbound inboundPayload;

        private Part(String name, String contentType, Properties props, Inbound inboundPayload) {
            super(contentType, name, props);
            this.inboundPayload = inboundPayload;
        }

        public InputStream getInputStream() {
            return new Inbound.ZipEntryInputStream(this.inboundPayload);
        }
    }

    static class Inbound
    extends PayloadImpl.Inbound {
        private final ZipInputStream zis;
        private ZipEntry nextEntry = null;
        private boolean isNextEntryPrefetched = false;

        private Inbound(InputStream is) throws IOException {
            this.zis = new ZipInputStream(new BufferedInputStream(is));
            this.prefetchNextEntry();
        }

        private void invalidateCurrentWrapperStream() {
        }

        private void prefetchNextEntry() throws IOException {
            this.invalidateCurrentWrapperStream();
            this.nextEntry = this.zis.getNextEntry();
            this.isNextEntryPrefetched = true;
        }

        private void recordZipEntryEOF() throws IOException {
            this.invalidateCurrentWrapperStream();
            this.prefetchNextEntry();
        }

        private void recordZipEntryNonEOF() {
            this.isNextEntryPrefetched = false;
        }

        public static Inbound newInstance(String payloadContentType, InputStream is) throws IOException {
            return new Inbound(is);
        }

        public static boolean supportsContentType(String contentType) {
            return ZipPayloadImpl.PAYLOAD_IMPL_CONTENT_TYPE.equalsIgnoreCase(contentType);
        }

        public Iterator<Payload.Part> parts() {
            return new Iterator<Payload.Part>(){

                @Override
                public boolean hasNext() {
                    if (!isNextEntryPrefetched) {
                        try {
                            this.prefetchNextEntry();
                        }
                        catch (IOException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                    return nextEntry != null;
                }

                @Override
                public Payload.Part next() {
                    Extra extra = new Extra(nextEntry.getExtra());
                    Part part = new Part(nextEntry.getName(), extra.getContentType(), extra.getProperties(), this);
                    isNextEntryPrefetched = false;
                    return part;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        private static class ZipEntryInputStream
        extends InputStream {
            private final ZipInputStream zis;
            private final Inbound inboundPayload;
            private boolean isValid = true;

            private ZipEntryInputStream(Inbound inboundPayload) {
                this.zis = inboundPayload.zis;
                this.inboundPayload = inboundPayload;
            }

            private void invalidate() {
                this.isValid = false;
            }

            private void checkValid() {
                if (!this.isValid) {
                    throw new IllegalStateException();
                }
            }

            @Override
            public int read() throws IOException {
                this.checkValid();
                int result = this.zis.read();
                if (result == -1) {
                    this.inboundPayload.recordZipEntryEOF();
                } else {
                    this.inboundPayload.recordZipEntryNonEOF();
                }
                return result;
            }

            @Override
            public int read(byte[] b) throws IOException {
                this.checkValid();
                int result = this.zis.read(b);
                if (result == -1) {
                    this.inboundPayload.recordZipEntryEOF();
                } else {
                    this.inboundPayload.recordZipEntryNonEOF();
                }
                return result;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                this.checkValid();
                int result = this.zis.read(b, off, len);
                if (result == -1) {
                    this.inboundPayload.recordZipEntryEOF();
                } else {
                    this.inboundPayload.recordZipEntryNonEOF();
                }
                return result;
            }

            @Override
            public void close() throws IOException {
                this.invalidate();
            }
        }
    }

    static class Outbound
    extends PayloadImpl.Outbound {
        private void prepareEntry(Payload.Part part, ZipOutputStream zos) throws IOException {
            ZipEntry entry = new ZipEntry(part.getName());
            Extra extra = new Extra(part.getContentType(), part.getProperties());
            entry.setExtra(extra.toBytes());
            zos.putNextEntry(entry);
        }

        @Override
        public void writePartsTo(OutputStream os) throws IOException {
            try (ZipOutputStream zos = new ZipOutputStream(os);){
                for (Payload.Part part : this.getParts()) {
                    this.prepareEntry(part, zos);
                    part.copy((OutputStream)zos);
                    zos.closeEntry();
                }
            }
        }

        private Outbound() {
        }

        public static Outbound newInstance() {
            return new Outbound();
        }

        @Override
        public String getComplexContentType() {
            return ZipPayloadImpl.PAYLOAD_IMPL_CONTENT_TYPE;
        }
    }
}

