/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.enterprise.inject.build.compatible.spi.ClassConfig;
import jakarta.enterprise.inject.build.compatible.spi.FieldConfig;
import jakarta.enterprise.inject.build.compatible.spi.MethodConfig;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.configurator.AnnotatedConstructorConfigurator;
import jakarta.enterprise.inject.spi.configurator.AnnotatedFieldConfigurator;
import jakarta.enterprise.inject.spi.configurator.AnnotatedMethodConfigurator;
import jakarta.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.declarations.ClassInfo;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.weld.lite.extension.translator.AnnotationInfoImpl;
import org.jboss.weld.lite.extension.translator.AnnotationProxy;
import org.jboss.weld.lite.extension.translator.ClassInfoImpl;
import org.jboss.weld.lite.extension.translator.FieldConfigImpl;
import org.jboss.weld.lite.extension.translator.MethodConfigImpl;
import org.jboss.weld.lite.extension.translator.MethodConstructorConfigImpl;

class ClassConfigImpl
implements ClassConfig {
    private final AnnotatedTypeConfigurator<?> configurator;
    private final BeanManager bm;

    ClassConfigImpl(AnnotatedTypeConfigurator<?> configurator, BeanManager bm) {
        this.configurator = configurator;
        this.bm = bm;
    }

    @Override
    public ClassInfo info() {
        return new ClassInfoImpl(this.configurator.getAnnotated(), this.bm);
    }

    @Override
    public ClassConfig addAnnotation(Class<? extends Annotation> annotationType) {
        this.configurator.add(AnnotationProxy.create(annotationType, Collections.emptyMap()));
        return this;
    }

    @Override
    public ClassConfig addAnnotation(AnnotationInfo annotation) {
        this.configurator.add(((AnnotationInfoImpl)annotation).annotation);
        return this;
    }

    @Override
    public ClassConfig addAnnotation(Annotation annotation) {
        this.configurator.add(annotation);
        return this;
    }

    @Override
    public ClassConfig removeAnnotation(Predicate<AnnotationInfo> predicate) {
        this.configurator.remove(annotation -> predicate.test(new AnnotationInfoImpl((Annotation)annotation, this.bm)));
        return this;
    }

    @Override
    public ClassConfig removeAllAnnotations() {
        this.configurator.removeAll();
        return this;
    }

    @Override
    public Collection<MethodConfig> constructors() {
        return this.configurator.constructors().stream().map(annotatedConstructorConfigurator -> new MethodConstructorConfigImpl((AnnotatedConstructorConfigurator<?>)annotatedConstructorConfigurator, this.bm)).collect(Collectors.toList());
    }

    @Override
    public Collection<MethodConfig> methods() {
        return this.configurator.methods().stream().map(annotatedMethodConfigurator -> new MethodConfigImpl((AnnotatedMethodConfigurator<?>)annotatedMethodConfigurator, this.bm)).collect(Collectors.toList());
    }

    @Override
    public Collection<FieldConfig> fields() {
        return this.configurator.fields().stream().map(annotatedFieldConfigurator -> new FieldConfigImpl((AnnotatedFieldConfigurator<?>)annotatedFieldConfigurator, this.bm)).collect(Collectors.toList());
    }
}

