/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.keyinfo;

import com.sun.xml.ws.security.opt.api.keyinfo.BinarySecurityToken;
import com.sun.xml.ws.security.opt.api.keyinfo.BuilderResult;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.crypto.OctectStreamData;
import com.sun.xml.ws.security.opt.impl.keyinfo.TokenBuilder;
import com.sun.xml.ws.security.opt.impl.reference.DirectReference;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.KeyBindingBase;
import com.sun.xml.wss.logging.impl.opt.token.LogStringsMessages;
import java.util.logging.Level;

public class KerberosTokenBuilder
extends TokenBuilder {
    AuthenticationTokenPolicy.KerberosTokenBinding binding = null;

    public KerberosTokenBuilder(JAXBFilterProcessingContext context, AuthenticationTokenPolicy.KerberosTokenBinding binding) {
        super(context);
        this.binding = binding;
    }

    @Override
    public BuilderResult process() throws XWSSecurityException {
        this.setIncludeTokenPolicy();
        String referenceType = this.binding.getReferenceType();
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, LogStringsMessages.WSS_1853_REFERENCETYPE_KERBEROS_TOKEN(referenceType));
        }
        BuilderResult result = new BuilderResult();
        if (referenceType.equals("Direct")) {
            BinarySecurityToken bst = this.createKerberosBST(this.binding, this.binding.getTokenValue());
            if (bst == null) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1802_WRONG_TOKENINCLUSION_POLICY());
                throw new XWSSecurityException(LogStringsMessages.WSS_1802_WRONG_TOKENINCLUSION_POLICY());
            }
            DirectReference dr = this.buildDirectReference(bst.getId(), "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ");
            this.buildKeyInfo(dr, this.binding.getSTRID());
        } else if (referenceType.equals("Identifier")) {
            BinarySecurityToken bst = this.createKerberosBST(this.binding, this.binding.getTokenValue());
            this.buildKeyInfoWithKIKerberos(this.binding, "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5APREQSHA1");
            if (this.binding.getSTRID() != null) {
                OctectStreamData osd = new OctectStreamData(new String(this.binding.getTokenValue()));
                this.context.getElementCache().put(this.binding.getSTRID(), osd);
            }
        } else {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1803_UNSUPPORTED_REFERENCE_TYPE(referenceType));
            throw new XWSSecurityException(LogStringsMessages.WSS_1803_UNSUPPORTED_REFERENCE_TYPE(referenceType));
        }
        result.setKeyInfo(this.keyInfo);
        return result;
    }

    private void setIncludeTokenPolicy() throws XWSSecurityException {
        if (!this.binding.policyTokenWasSet()) {
            return;
        }
        String itVersion = this.binding.getIncludeToken();
        if (KeyBindingBase.INCLUDE_ALWAYS.equals(itVersion) || KeyBindingBase.INCLUDE_ALWAYS_TO_RECIPIENT.equals(itVersion) || KeyBindingBase.INCLUDE_ALWAYS_VER2.equals(itVersion) || KeyBindingBase.INCLUDE_ALWAYS_TO_RECIPIENT_VER2.equals(itVersion)) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1822_KERBEROS_ALWAYS_NOTALLOWED());
            throw new XWSSecurityException(LogStringsMessages.WSS_1822_KERBEROS_ALWAYS_NOTALLOWED());
        }
        if (KeyBindingBase.INCLUDE_NEVER.equals(itVersion) || KeyBindingBase.INCLUDE_NEVER_VER2.equals(itVersion)) {
            this.binding.setReferenceType("Identifier");
        } else if (KeyBindingBase.INCLUDE_ONCE.equals(itVersion) || KeyBindingBase.INCLUDE_ONCE_VER2.equals(itVersion)) {
            this.binding.setReferenceType("Direct");
        }
    }
}

