# Concurrency TCK Signature Tests

This package is inherited from the Platform-TCK (https://github.com/eclipse-ee4j/jakartaee-tck/tree/master/src/com/sun/ts/tests/signaturetest)

The latest signature files are updated in the concurrency TCK Repository 
(concurrency-api//tck/src/main/resources/ee/jakarta/tck/spec/signature) 
generated using sigtest-maven-plugin.jar (version 2.3).

The signature tests are run using the sigtest-maven-plugin.jar and the framework available in this folder.

## For TCK developers

### The configuration

The signature file will be generated by the Concurrency team using the `tck/pom.xml`. 
The pom.xml has a `signature-generation` profile configured for this purpose.
The plugin that generates the signature file has been copied below for reference:


```xml
<plugin>
	<groupId>jakarta.tck</groupId>
	<artifactId>sigtest-maven-plugin</artifactId>
	<version>${sigtest.version}</version>
	<executions>
		<execution>
			<id>createSigFile</id>
			<goals>
				<goal>generate</goal>
			</goals>
		</execution>
	</executions>
	<configuration>
		<classes>${project.build.directory}/concurrency-api</classes>
		<classes>${project.build.directory}/jimage/java.base</classes><classes>${project.build.directory}/jimage/java.base</classes>
		<packages>
			jakarta.enterprise.concurrent,
			jakarta.enterprise.concurrent.spi,
		</packages>
		<attach>false</attach>
		<sigfile>${project.build.directory}/jakarta.enterprise.concurrent.sig_${java.version}</sigfile>
	</configuration>
</plugin>
```

- The `classes` configuration points to a location where an earlier plugin has unpacked the api jar from which we are generating the signature file.
- The `packages` configuration specifies the packages we want to generate signatures from. 
- The `attach` configuration specifies that we do not want the plugin to use its default file extension
- The `sigfile` configurations specifies the signature file we want the plugin to generate

### Generating the Signature File

> NOTE: A GitHub actions workflow automatically updates signature files after API updates so this only needs to happen 
> when creating a new signature file for a newly support JDK level.

To generate the signature file first build the API:

```sh
cd api
mvn package
```

Then build the TCK with the `signature-generation` profile to re-generate the signature file:

```sh
cd ../tck
mvn package -Psignature-generation
```

The signature file will be generated in the `/target/` directory.

The signature file will be automatically copied to the `/src/main/resource/ee/jakarta/tck/concurrent/common/signature/` directory.

## For TCK users

### Running signature tests

Since the Concurrency TCK can only be run against Jakarta EE Servers we have simplified the running of signature tests.

Signature tests will be automatically run as part of the TCK via the `ee.jakarta.tck.concurrent.spec.signature` package. 

This package will deploy an application to the Jakarta EE Server. 
The application runs the signature test using the signaturetest framework from the Platform TCK.
