/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.api.ManagedTask;

import ee.jakarta.tck.concurrent.common.managed.task.listener.ManagedTaskListenerImpl;
import ee.jakarta.tck.concurrent.common.tasks.RunnableTask;
import ee.jakarta.tck.concurrent.framework.junit.anno.Assertion;
import ee.jakarta.tck.concurrent.framework.junit.anno.Common;
import ee.jakarta.tck.concurrent.framework.junit.anno.Web;
import jakarta.enterprise.concurrent.ManagedExecutors;
import jakarta.enterprise.concurrent.ManagedTask;
import jakarta.enterprise.concurrent.ManagedTaskListener;
import java.util.HashMap;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Assertions;

@Web
@Common(value={Common.PACKAGE.MANAGED_TASK_LISTENER, Common.PACKAGE.TASKS})
public class ManagedTaskTests {
    private ManagedTaskListenerImpl managedTaskListener = new ManagedTaskListenerImpl();

    @Deployment(name="ManagedTaskTests")
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addPackages(true, new Package[]{ManagedTaskTests.class.getPackage()});
    }

    private RunnableTask createRunnableTask() {
        return new RunnableTask("java:comp/env/StringValue", "FakeValue", this.getClass().getName());
    }

    @Assertion(id="JAVADOC:36", strategy="Get ManagedTask to provides additional information to the ManagedExecutorService or ManagedScheduledExecutorService when executing this task.")
    public void getExecutionProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("key", "value");
        RunnableTask runnableTask = this.createRunnableTask();
        Runnable task = ManagedExecutors.managedTask((Runnable)runnableTask, properties, (ManagedTaskListener)this.managedTaskListener);
        Assertions.assertTrue((boolean)(task instanceof ManagedTask));
        ManagedTask managedTask = (ManagedTask)task;
        Assertions.assertEquals((Object)"value", managedTask.getExecutionProperties().get("key"));
    }

    @Assertion(id="JAVADOC:37", strategy="Get ManagedTask with ManagedTaskListener to receive notification of life cycle events of this task.")
    public void getManagedTaskListener() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("key", "value");
        RunnableTask runnableTask = this.createRunnableTask();
        Runnable task = ManagedExecutors.managedTask((Runnable)runnableTask, properties, (ManagedTaskListener)this.managedTaskListener);
        Assertions.assertTrue((boolean)(task instanceof ManagedTask));
        ManagedTask managedTask = (ManagedTask)task;
        Assertions.assertEquals((Object)this.managedTaskListener, (Object)managedTask.getManagedTaskListener());
    }
}

