/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.label;

import java.text.MessageFormat;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emfforms.internal.core.services.label.BundleKeyResultWrapper;
import org.eclipse.emfforms.internal.core.services.label.BundleKeyWrapper;
import org.eclipse.emfforms.internal.core.services.label.BundleResolver;
import org.eclipse.emfforms.internal.core.services.label.BundleResolverImpl;
import org.eclipse.emfforms.internal.core.services.label.EMFFormsLabelProviderDefaultImpl;
import org.eclipse.emfforms.spi.common.locale.EMFFormsLocaleChangeListener;
import org.eclipse.emfforms.spi.common.locale.EMFFormsLocaleProvider;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.core.services.label.NoLabelFoundException;
import org.eclipse.emfforms.spi.localization.EMFFormsLocalizationService;
import org.osgi.framework.Bundle;

public class EMFFormsLabelProviderImpl
implements EMFFormsLabelProvider,
EMFFormsLocaleChangeListener {
    private static final String DISPLAY_NAME = "_UI_%1$s_%2$s_feature";
    private static final String DESCRIPTION = "_UI_%1$s_%2$s_description";
    private static final String DESCRIPTION_COMPOSITE = "_UI_PropertyDescriptor_description";
    private static final String TYPE = "_UI_%1$s_type";
    private EMFFormsDatabinding emfFormsDatabinding;
    private EMFFormsLocalizationService localizationService;
    private ReportService reportService;
    private BundleResolver bundleResolver = new BundleResolverImpl();
    private final Map<WritableValue, BundleKeyWrapper> displayKeyObservableMap = new WeakHashMap<WritableValue, BundleKeyWrapper>();
    private final Map<WritableValue, DescriptionKey> descriptionKeyObservableMap = new WeakHashMap<WritableValue, DescriptionKey>();
    private EMFFormsLocaleProvider localeProvider;
    private EMFFormsLabelProviderDefaultImpl labelProviderDefault;

    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    protected void setEMFFormsDatabinding(EMFFormsDatabinding emfFormsDatabinding) {
        this.emfFormsDatabinding = emfFormsDatabinding;
    }

    protected void setEMFFormsLocalizationService(EMFFormsLocalizationService localizationService) {
        this.localizationService = localizationService;
    }

    protected void setEMFFormsLocaleProvider(EMFFormsLocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
        this.localeProvider.addEMFFormsLocaleChangeListener((EMFFormsLocaleChangeListener)this);
    }

    protected void setBundleResolver(BundleResolver bundleResolver) {
        this.bundleResolver = bundleResolver;
    }

    protected void setLabelProviderDefault(EMFFormsLabelProviderDefaultImpl labelProviderDefault) {
        this.labelProviderDefault = labelProviderDefault;
    }

    private BundleKeyResultWrapper getDisplayBundleKeyResultWrapper(EStructuralFeature structuralFeature) throws BundleResolver.NoBundleFoundException {
        EClass eContainingClass = structuralFeature.getEContainingClass();
        Bundle bundle = this.bundleResolver.getEditBundle(eContainingClass);
        String key = String.format(DISPLAY_NAME, eContainingClass.getName(), structuralFeature.getName());
        String displayName = this.getDisplayName(bundle, key);
        return new BundleKeyResultWrapper(new BundleKeyWrapper(key, bundle), displayName);
    }

    public String getDisplayName(EStructuralFeature structuralFeature) {
        try {
            return this.getDisplayBundleKeyResultWrapper(structuralFeature).getResult();
        }
        catch (BundleResolver.NoBundleFoundException ex) {
            return this.labelProviderDefault.getDisplayName(structuralFeature);
        }
    }

    public IObservableValue getDisplayName(VDomainModelReference domainModelReference) throws NoLabelFoundException {
        BundleKeyResultWrapper bundleKeyResultWrapper;
        IValueProperty valueProperty;
        Assert.create((Object)domainModelReference).notNull();
        try {
            valueProperty = this.emfFormsDatabinding.getValueProperty(domainModelReference, null);
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            throw new NoLabelFoundException((Exception)((Object)ex));
        }
        EStructuralFeature structuralFeature = (EStructuralFeature)valueProperty.getValueType();
        try {
            bundleKeyResultWrapper = this.getDisplayBundleKeyResultWrapper(structuralFeature);
        }
        catch (BundleResolver.NoBundleFoundException ex) {
            return this.labelProviderDefault.getDisplayName(domainModelReference);
        }
        WritableValue value = this.getObservableValue(bundleKeyResultWrapper.getResult());
        this.displayKeyObservableMap.put(value, bundleKeyResultWrapper.getBundleKeyWrapper());
        return value;
    }

    public IObservableValue getDisplayName(VDomainModelReference domainModelReference, EObject rootObject) throws NoLabelFoundException {
        BundleKeyResultWrapper displayBundleKeyResultWrapper;
        IValueProperty valueProperty;
        Assert.create((Object)domainModelReference).notNull();
        Assert.create((Object)rootObject).notNull();
        try {
            valueProperty = this.emfFormsDatabinding.getValueProperty(domainModelReference, rootObject);
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            throw new NoLabelFoundException((Exception)((Object)ex));
        }
        EStructuralFeature structuralFeature = (EStructuralFeature)valueProperty.getValueType();
        try {
            displayBundleKeyResultWrapper = this.getDisplayBundleKeyResultWrapper(structuralFeature);
        }
        catch (BundleResolver.NoBundleFoundException ex) {
            return this.labelProviderDefault.getDisplayName(domainModelReference, rootObject);
        }
        WritableValue displayObserveValue = this.getObservableValue(displayBundleKeyResultWrapper.getResult());
        this.displayKeyObservableMap.put(displayObserveValue, displayBundleKeyResultWrapper.getBundleKeyWrapper());
        return displayObserveValue;
    }

    public IObservableValue getDescription(VDomainModelReference domainModelReference) throws NoLabelFoundException {
        Bundle bundle;
        IValueProperty valueProperty;
        Assert.create((Object)domainModelReference).notNull();
        try {
            valueProperty = this.emfFormsDatabinding.getValueProperty(domainModelReference, null);
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            throw new NoLabelFoundException((Exception)((Object)ex));
        }
        EStructuralFeature structuralFeature = (EStructuralFeature)valueProperty.getValueType();
        EClass eContainingClass = structuralFeature.getEContainingClass();
        try {
            bundle = this.bundleResolver.getEditBundle(eContainingClass);
        }
        catch (BundleResolver.NoBundleFoundException ex) {
            return this.labelProviderDefault.getDescription(domainModelReference);
        }
        WritableValue writableValue = this.getObservableValue(this.getDescription(eContainingClass.getName(), structuralFeature.getName(), bundle));
        this.descriptionKeyObservableMap.put(writableValue, new DescriptionKey(eContainingClass.getName(), structuralFeature.getName(), bundle));
        return writableValue;
    }

    public IObservableValue getDescription(VDomainModelReference domainModelReference, EObject rootObject) throws NoLabelFoundException {
        Bundle bundle;
        IValueProperty valueProperty;
        Assert.create((Object)domainModelReference).notNull();
        Assert.create((Object)rootObject).notNull();
        try {
            valueProperty = this.emfFormsDatabinding.getValueProperty(domainModelReference, rootObject);
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            throw new NoLabelFoundException((Exception)((Object)ex));
        }
        EStructuralFeature structuralFeature = (EStructuralFeature)valueProperty.getValueType();
        try {
            bundle = this.bundleResolver.getEditBundle(structuralFeature.getEContainingClass());
        }
        catch (BundleResolver.NoBundleFoundException ex) {
            return this.labelProviderDefault.getDescription(domainModelReference, rootObject);
        }
        WritableValue writableValue = this.getObservableValue(this.getDescription(structuralFeature.getEContainingClass().getName(), structuralFeature.getName(), bundle));
        this.descriptionKeyObservableMap.put(writableValue, new DescriptionKey(structuralFeature.getEContainingClass().getName(), structuralFeature.getName(), bundle));
        return writableValue;
    }

    private WritableValue getObservableValue(String value) {
        return new WritableValue((Object)value, String.class);
    }

    private String getDisplayName(Bundle bundle, String key) {
        return this.localizationService.getString(bundle, key);
    }

    private String getDescription(String eClassName, String featureName, Bundle bundle) {
        String keyDefault = String.format(DESCRIPTION, eClassName, featureName);
        if (this.localizationService.hasKey(bundle, keyDefault)) {
            return this.localizationService.getString(bundle, keyDefault);
        }
        String descriptionWithSubstitution = this.localizationService.getString(bundle, DESCRIPTION_COMPOSITE);
        String key = String.format(DISPLAY_NAME, eClassName, featureName);
        String featureSubstitution = this.getDisplayName(bundle, key);
        String eObjectSubstitution = this.localizationService.getString(bundle, String.format(TYPE, eClassName));
        return MessageFormat.format(descriptionWithSubstitution, featureSubstitution, eObjectSubstitution);
    }

    public void notifyLocaleChange() {
        WritableValue writableValue;
        for (Map.Entry<WritableValue, BundleKeyWrapper> entry : this.displayKeyObservableMap.entrySet()) {
            BundleKeyWrapper displayNameKey = entry.getValue();
            writableValue = entry.getKey();
            writableValue.setValue((Object)this.getDisplayName(displayNameKey.getBundle(), displayNameKey.getKey()));
        }
        for (Map.Entry<WritableValue, Object> entry : this.descriptionKeyObservableMap.entrySet()) {
            DescriptionKey descriptionKey = (DescriptionKey)entry.getValue();
            writableValue = entry.getKey();
            writableValue.setValue((Object)this.getDescription(descriptionKey.geteClassName(), descriptionKey.getFeatureName(), descriptionKey.getBundle()));
        }
    }

    private static class DescriptionKey {
        private final String eClassName;
        private final String featureName;
        private final Bundle bundle;

        DescriptionKey(String eClassName, String featureName, Bundle bundle) {
            this.eClassName = eClassName;
            this.featureName = featureName;
            this.bundle = bundle;
        }

        Bundle getBundle() {
            return this.bundle;
        }

        String geteClassName() {
            return this.eClassName;
        }

        String getFeatureName() {
            return this.featureName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.bundle == null ? 0 : this.bundle.hashCode());
            result = 31 * result + (this.eClassName == null ? 0 : this.eClassName.hashCode());
            result = 31 * result + (this.featureName == null ? 0 : this.featureName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof DescriptionKey)) {
                return false;
            }
            DescriptionKey other = (DescriptionKey)obj;
            if (this.bundle == null ? other.bundle != null : !this.bundle.equals(other.bundle)) {
                return false;
            }
            if (this.eClassName == null ? other.eClassName != null : !this.eClassName.equals(other.eClassName)) {
                return false;
            }
            return !(this.featureName == null ? other.featureName != null : !this.featureName.equals(other.featureName));
        }
    }
}

