/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.edit.parts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecoretools.diagram.edit.figures.AlphaDropShadowBorder;
import org.eclipse.emf.ecoretools.diagram.edit.figures.FigureFromLabelUtils;
import org.eclipse.emf.ecoretools.diagram.edit.figures.GradientRectangleFigure;
import org.eclipse.emf.ecoretools.diagram.edit.figures.PackageLabelRectangle;
import org.eclipse.emf.ecoretools.diagram.edit.parts.EPackageContentsEditPart;
import org.eclipse.emf.ecoretools.diagram.edit.parts.EPackageNameEditPart;
import org.eclipse.emf.ecoretools.diagram.edit.policies.AlphaResizableShapeEditPolicy;
import org.eclipse.emf.ecoretools.diagram.edit.policies.EPackage2ItemSemanticEditPolicy;
import org.eclipse.emf.ecoretools.diagram.edit.policies.OpenDiagramEditPolicy;
import org.eclipse.emf.ecoretools.diagram.part.EcoreVisualIDRegistry;
import org.eclipse.emf.ecoretools.diagram.providers.EcoreElementTypes;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;

public class EPackage2EditPart
extends ShapeNodeEditPart {
    public static final int VISUAL_ID = 1002;
    protected IFigure contentPane;
    protected IFigure primaryShape;

    public EPackage2EditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new EPackage2ItemSemanticEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
        this.installEditPolicy("OpenPolicy", (EditPolicy)new OpenDiagramEditPolicy());
        this.removeEditPolicy("ConnectionHandlesPolicy");
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        LayoutEditPolicy lep = new LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        PackageFigure figure = new PackageFigure();
        figure.setShouldUseGradient(Boolean.TRUE.equals(this.getViewer().getProperty("Appearance.fillFigureUsingGradient")));
        this.primaryShape = figure;
        return this.primaryShape;
    }

    public PackageFigure getPrimaryShape() {
        return (PackageFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof EPackageNameEditPart) {
            ((EPackageNameEditPart)childEditPart).setLabel(this.getPrimaryShape().getFigurePackageNameLabel());
            return true;
        }
        if (childEditPart instanceof EPackageContentsEditPart) {
            RectangleFigure pane = this.getPrimaryShape().getFigurePackageBodyRectangle();
            this.setupContentPane((IFigure)pane);
            pane.add(((EPackageContentsEditPart)childEditPart).getFigure());
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof EPackageNameEditPart) {
            return true;
        }
        if (childEditPart instanceof EPackageContentsEditPart) {
            RectangleFigure pane = this.getPrimaryShape().getFigurePackageBodyRectangle();
            this.setupContentPane((IFigure)pane);
            pane.remove(((EPackageContentsEditPart)childEditPart).getFigure());
            return true;
        }
        return false;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        if (editPart instanceof EPackageContentsEditPart) {
            return this.getPrimaryShape().getFigurePackageBodyRectangle();
        }
        return this.getContentPane();
    }

    protected NodeFigure createNodePlate() {
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(this.getMapMode().DPtoLP(40), this.getMapMode().DPtoLP(40)){

            public PointList getPolygonPoints() {
                PointList points = new PointList(7);
                Rectangle nameRectangle = EPackage2EditPart.this.getPrimaryShape().getFigurePackageLabelRectangle().getBounds();
                Rectangle bodyRectangle = EPackage2EditPart.this.getPrimaryShape().getFigurePackageBodyRectangle().getBounds();
                points.addPoint(nameRectangle.x, nameRectangle.y);
                points.addPoint(nameRectangle.x + nameRectangle.width, nameRectangle.y);
                points.addPoint(nameRectangle.x + nameRectangle.width, nameRectangle.y + nameRectangle.height);
                points.addPoint(bodyRectangle.x + bodyRectangle.width, bodyRectangle.y);
                points.addPoint(bodyRectangle.x + bodyRectangle.width, bodyRectangle.y + bodyRectangle.height);
                points.addPoint(bodyRectangle.x, bodyRectangle.y + bodyRectangle.height);
                points.addPoint(nameRectangle.x, nameRectangle.y);
                return points;
            }
        };
        AlphaDropShadowBorder shadowBorder = new AlphaDropShadowBorder();
        shadowBorder.setShouldDrawDropShadow(Boolean.TRUE.equals(this.getViewer().getProperty("Appearance.useShadowOnBorder")));
        result.setBorder((Border)shadowBorder);
        return result;
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(this.getMapMode().DPtoLP(5));
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected void setForegroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setForegroundColor(color);
        }
    }

    protected void setBackgroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setBackgroundColor(color);
        }
    }

    protected void setLineWidth(int width) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineWidth(this.getMapMode().DPtoLP(width));
        }
    }

    protected void setLineType(int style) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineStyle(style);
        }
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(EcoreVisualIDRegistry.getType(4006));
    }

    public List<IElementType> getMARelTypesOnTarget() {
        ArrayList<IElementType> types = new ArrayList<IElementType>();
        types.add(EcoreElementTypes.EAnnotationReferences_3001);
        return types;
    }

    public List<IElementType> getMATypesForSource(IElementType relationshipType) {
        ArrayList<IElementType> types = new ArrayList<IElementType>();
        if (relationshipType == EcoreElementTypes.EAnnotationReferences_3001) {
            types.add(EcoreElementTypes.EAnnotation_1003);
        }
        return types;
    }

    protected void handleNotificationEvent(Notification event) {
        if (event.getNotifier() == this.getModel() && EcorePackage.eINSTANCE.getEModelElement_EAnnotations().equals(event.getFeature())) {
            this.handleMajorSemanticChange();
        } else {
            super.handleNotificationEvent(event);
        }
    }

    protected void refreshVisuals() {
        EObject semanticElement = this.resolveSemanticElement();
        if (FigureFromLabelUtils.needFromLabel(semanticElement, this.getNotationView())) {
            this.getPrimaryShape().updateFromLabel(FigureFromLabelUtils.getQualifiedName(semanticElement));
            this.getPrimaryShape().addFromLabel();
        } else {
            this.getPrimaryShape().removeFromLabel();
        }
        super.refreshVisuals();
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        return new AlphaResizableShapeEditPolicy();
    }

    public class PackageFigure
    extends GradientRectangleFigure {
        private GradientRectangleFigure fFigurePackageBodyRectangle;
        private WrappingLabel fFigurePackageNameLabel;
        private RectangleFigure fFigurePackageLabelRectangle;
        private boolean myUseLocalCoordinates = false;
        private boolean canRemovedFromLabel;
        private WrappingLabel fFigureFromLabel;

        public PackageFigure() {
            GridLayout layoutThis = new GridLayout();
            layoutThis.numColumns = 2;
            layoutThis.makeColumnsEqualWidth = false;
            layoutThis.horizontalSpacing = 0;
            layoutThis.verticalSpacing = 0;
            layoutThis.marginWidth = 0;
            layoutThis.marginHeight = 0;
            this.setLayoutManager((LayoutManager)layoutThis);
            this.setFill(false);
            this.setOutline(false);
            this.setLineWidth(2);
            this.setMinimumSize(new Dimension(EPackage2EditPart.this.getMapMode().DPtoLP(110), EPackage2EditPart.this.getMapMode().DPtoLP(100)));
            this.createContents();
        }

        private void createContents() {
            this.fFigurePackageLabelRectangle = new PackageLabelRectangle();
            this.fFigurePackageLabelRectangle.setLineWidth(1);
            this.fFigurePackageLabelRectangle.setBorder((Border)new MarginBorder(EPackage2EditPart.this.getMapMode().DPtoLP(5), EPackage2EditPart.this.getMapMode().DPtoLP(5), EPackage2EditPart.this.getMapMode().DPtoLP(5), EPackage2EditPart.this.getMapMode().DPtoLP(5)));
            GridData constraintPackageLabelRectangle0 = new GridData();
            constraintPackageLabelRectangle0.verticalAlignment = 1;
            constraintPackageLabelRectangle0.horizontalAlignment = 1;
            constraintPackageLabelRectangle0.horizontalIndent = 0;
            constraintPackageLabelRectangle0.horizontalSpan = 1;
            constraintPackageLabelRectangle0.verticalSpan = 1;
            constraintPackageLabelRectangle0.grabExcessHorizontalSpace = false;
            constraintPackageLabelRectangle0.grabExcessVerticalSpace = false;
            this.add((IFigure)this.fFigurePackageLabelRectangle, constraintPackageLabelRectangle0);
            ToolbarLayout layoutPackageLabelRectangle0 = new ToolbarLayout();
            layoutPackageLabelRectangle0.setStretchMinorAxis(false);
            layoutPackageLabelRectangle0.setMinorAlignment(1);
            layoutPackageLabelRectangle0.setSpacing(5);
            layoutPackageLabelRectangle0.setVertical(true);
            this.fFigurePackageLabelRectangle.setLayoutManager((LayoutManager)layoutPackageLabelRectangle0);
            this.fFigurePackageNameLabel = new WrappingLabel();
            this.fFigurePackageNameLabel.setText("<..>");
            this.fFigurePackageLabelRectangle.add((IFigure)this.fFigurePackageNameLabel);
            this.fFigureFromLabel = new WrappingLabel();
            this.fFigureFromLabel.setAlignment(8);
            this.fFigureFromLabel.setText("<..>");
            RectangleFigure fillerFigure0 = new RectangleFigure();
            GridData constraintFillerFigure0 = new GridData();
            constraintFillerFigure0.verticalAlignment = 2;
            constraintFillerFigure0.horizontalAlignment = 2;
            constraintFillerFigure0.horizontalIndent = 0;
            constraintFillerFigure0.horizontalSpan = 1;
            constraintFillerFigure0.verticalSpan = 1;
            constraintFillerFigure0.grabExcessHorizontalSpace = false;
            constraintFillerFigure0.grabExcessVerticalSpace = false;
            this.add((IFigure)fillerFigure0, constraintFillerFigure0);
            this.fFigurePackageBodyRectangle = new GradientRectangleFigure();
            this.fFigurePackageBodyRectangle.setShouldUseGradient(Boolean.TRUE.equals(EPackage2EditPart.this.getViewer().getProperty("Appearance.fillFigureUsingGradient")));
            this.fFigurePackageBodyRectangle.setLineWidth(1);
            GridData constraintFFigurePackageBodyRectangle = new GridData();
            constraintFFigurePackageBodyRectangle.verticalAlignment = 4;
            constraintFFigurePackageBodyRectangle.horizontalAlignment = 4;
            constraintFFigurePackageBodyRectangle.horizontalIndent = 0;
            constraintFFigurePackageBodyRectangle.horizontalSpan = 1;
            constraintFFigurePackageBodyRectangle.verticalSpan = 1;
            constraintFFigurePackageBodyRectangle.grabExcessHorizontalSpace = true;
            constraintFFigurePackageBodyRectangle.grabExcessVerticalSpace = true;
            this.add((IFigure)this.fFigurePackageBodyRectangle, constraintFFigurePackageBodyRectangle);
        }

        protected boolean useLocalCoordinates() {
            return this.myUseLocalCoordinates;
        }

        protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
            this.myUseLocalCoordinates = useLocalCoordinates;
        }

        public RectangleFigure getFigurePackageBodyRectangle() {
            return this.fFigurePackageBodyRectangle;
        }

        public WrappingLabel getFigurePackageNameLabel() {
            return this.fFigurePackageNameLabel;
        }

        public RectangleFigure getFigurePackageLabelRectangle() {
            return this.fFigurePackageLabelRectangle;
        }

        public void addFromLabel() {
            this.fFigurePackageLabelRectangle.add((IFigure)this.getFigureFromLabel(), 1);
            this.canRemovedFromLabel = true;
        }

        public WrappingLabel getFigureFromLabel() {
            return this.fFigureFromLabel;
        }

        public void removeFromLabel() {
            if (this.canRemovedFromLabel) {
                this.fFigurePackageLabelRectangle.remove((IFigure)this.getFigureFromLabel());
                this.canRemovedFromLabel = false;
            }
        }

        public void updateFromLabel(String text) {
            this.getFigureFromLabel().setText(text);
        }
    }
}

