/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.sign;

import org.eclipse.ease.Logger;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PasswordDialog
extends Dialog {
    protected Text fPasswordText;
    protected String fNodeName;
    protected String fPassword;
    protected String fTitle;
    protected Button fSavePassCheckButton;

    protected PasswordDialog(Shell parentShell, String nodeName, String title) {
        super(parentShell);
        this.fTitle = title;
        this.fNodeName = nodeName;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        Label aliasLabel = new Label(container, 0);
        GridData gridData = new GridData(16384, 0x1000000, false, true, 1, 1);
        aliasLabel.setText("Enter Password");
        aliasLabel.setLayoutData((Object)gridData);
        this.fPasswordText = new Text(container, 0x400800);
        gridData = new GridData(16384, 0x1000000, true, true, 1, 1);
        this.fPasswordText.setLayoutData((Object)gridData);
        Group group = new Group(container, 0);
        group.setLayout((Layout)new RowLayout(256));
        this.fSavePassCheckButton = new Button((Composite)group, 32);
        Label checkBoxLabel = new Label((Composite)group, 0);
        checkBoxLabel.setText("Save Password");
        gridData = new GridData(16384, 0x1000000, false, true, 1, 1);
        group.setLayoutData((Object)gridData);
        this.initialize();
        return container;
    }

    protected void initialize() {
        ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
        ISecurePreferences node = preferences.node("KeystoreAliasPass");
        try {
            this.fPasswordText.setText(node.get(this.fNodeName, ""));
        }
        catch (StorageException e) {
            Logger.error((String)"org.eclipse.ease.ui", (String)e.getMessage(), (Throwable)e);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.fTitle);
    }

    protected void okPressed() {
        this.fPassword = this.fPasswordText.getText();
        if (this.fSavePassCheckButton.getSelection()) {
            ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
            ISecurePreferences node = preferences.node("KeystoreAliasPass");
            try {
                node.put(this.fNodeName, this.fPasswordText.getText(), true);
            }
            catch (StorageException e) {
                Logger.error((String)"org.eclipse.ease.ui", (String)e.getMessage(), (Throwable)e);
            }
        }
        super.okPressed();
    }

    String getPassword() {
        return this.fPassword;
    }
}

