/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.modeling;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ease.ICodeFactory;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Logger;
import org.eclipse.ease.modules.AbstractScriptModule;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.ease.modules.modeling.DialogModule;
import org.eclipse.ease.modules.modeling.EMFMarkerUtil;
import org.eclipse.ease.modules.modeling.GMFtoEMFCommandWrapper;
import org.eclipse.ease.modules.modeling.SelectionModule;
import org.eclipse.ease.modules.modeling.ui.UriSelectionDialog;
import org.eclipse.ease.modules.platform.ResourcesModule;
import org.eclipse.ease.modules.platform.UIModule;
import org.eclipse.ease.service.ScriptService;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Element;

public class EcoreModule
extends AbstractScriptModule {
    private String fUri;
    protected static Predicate<Method> createMethodFilter = arg0 -> {
        if (arg0 != null) {
            return arg0.getName().startsWith("create");
        }
        return false;
    };
    private static ComposedAdapterFactory adapter = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);

    public EObject getSelection() {
        Object selection = this.getSelectionModule().getCustomSelectionFromSelector("GMFSemanticSelector");
        if (selection instanceof EObject) {
            if (selection instanceof Element) {
                EList eList = ((Element)selection).getAppliedStereotypes();
            }
            return (EObject)selection;
        }
        String message = "Unable to retreive a EObject from the selection";
        ((UIModule)this.getEnvironment().getModule(UIModule.class)).showErrorDialog("Error", "Unable to retreive a EObject from the selection");
        return null;
    }

    private SelectionModule getSelectionModule() {
        return (SelectionModule)((Object)this.getEnvironment().getModule(SelectionModule.class));
    }

    @WrapToScript
    public boolean eInstanceOf(@ScriptParameter(name="eObject") EObject eObject, @ScriptParameter(name="type") String type) {
        EClassifier classifier = this.getEPackage().getEClassifier(type);
        if (classifier == null) {
            ((UIModule)this.getEnvironment().getModule(UIModule.class)).showErrorDialog("Error", "Unable to find EClass named :" + type);
        }
        return classifier.isInstance((Object)eObject);
    }

    protected String getUri() {
        return this.fUri;
    }

    @WrapToScript
    public EObject getSelection(@ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null", name="type") String type) {
        EObject selection = this.getSelection();
        if (type != null) {
            if (this.eInstanceOf(selection, type)) {
                return selection;
            }
            return null;
        }
        return selection;
    }

    protected String getFactoryVariableName() {
        return "__" + this.getEPackage().getName().toUpperCase() + "__FACTORY";
    }

    @WrapToScript
    public void initEPackage(@ScriptParameter(name="nsURI") String nsURI) {
        if (nsURI == null) {
            this.initEPackageFromDialog();
        } else {
            this.fUri = nsURI;
        }
        EPackage ePack = this.getEPackage();
        if (ePack == null) {
            ((UIModule)this.getEnvironment().getModule(UIModule.class)).showErrorDialog("Error", "Unable to find metamodel with URI : " + this.fUri);
            return;
        }
        EFactory factory = this.getFactory();
        if (factory != null) {
            this.getScriptEngine().setVariable(this.getFactoryVariableName(), (Object)factory);
            this.getEnvironment().wrap(factory.getClass(), false);
        } else {
            ((UIModule)this.getEnvironment().getModule(UIModule.class)).showErrorDialog("Error", "Unable to find metamodel with URI : " + this.fUri);
        }
    }

    @WrapToScript
    public Resource createResource(@ScriptParameter(name="name", defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String name, @ScriptParameter(name="uri", defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String uri) {
        ResourceSet resourceSet = this.getResourceSet();
        if (resourceSet == null) {
            Logger.warning((String)"org.eclipse.ease.modules.modeling", (String)"Unable to get the current resourceSet. Creating a new one...");
            resourceSet = new ResourceSetImpl();
        }
        URI resourceURI = this.createURI(uri, name);
        Resource resource = null;
        try {
            resource = resourceSet.getResource(resourceURI, true);
        }
        catch (Exception e) {
            resource = resourceSet.createResource(resourceURI);
        }
        return resource;
    }

    @WrapToScript
    public URI createURI(@ScriptParameter(name="containerURI", defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String containerURI, @ScriptParameter(name="fileName", defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String fileName) {
        URI container = null;
        if (containerURI == null) {
            String location = ((ResourcesModule)this.getEnvironment().getModule(ResourcesModule.class)).showFolderSelectionDialog(null, "Select where you want to add your resource", null);
            if (location == null || location.isEmpty()) {
                ((UIModule)this.getEnvironment().getModule(UIModule.class)).showErrorDialog("Error", "Unable to retreive a container for the new resource from your selestion");
                return null;
            }
            IPath containerPath = ((IResource)ResourceTools.resolve((Object)location)).getFullPath();
            container = URI.createPlatformResourceURI((String)containerPath.toString(), (boolean)true);
        } else {
            container = URI.createFileURI((String)containerURI);
        }
        if (fileName == null) {
            fileName = ((UIModule)this.getEnvironment().getModule(UIModule.class)).showInputDialog("", "Give the resource name (With it's extension)", "");
        }
        container = container.appendSegment(fileName);
        return container;
    }

    @WrapToScript
    public EFactory getFactory() {
        EPackage ePackage;
        if (this.fUri == null) {
            this.initEPackageFromDialog();
        }
        if ((ePackage = this.getEPackage()) == null) {
            throw new RuntimeException("Unable to retreive EPackage with URI " + this.fUri);
        }
        return ePackage.getEFactoryInstance();
    }

    @WrapToScript
    public EPackage getEPackage() {
        if (this.fUri == null) {
            this.initEPackageFromDialog();
        }
        EPackage ePack = EPackage.Registry.INSTANCE.getEPackage(this.fUri);
        return ePack;
    }

    private void initEPackageFromDialog() {
        Object[] result;
        this.getEnvironment().getModule(UIModule.class);
        UriSelectionDialog dialog = new UriSelectionDialog(UIModule.getShell());
        int returnCode = DialogModule.openDialog((Window)dialog);
        if (returnCode == 0 && (result = dialog.getResult()) != null && result.length == 1) {
            this.fUri = (String)result[0];
        }
    }

    @WrapToScript
    public void addErrorMarker(@ScriptParameter(name="eObject") EObject eObject, @ScriptParameter(name="message") String message) throws CoreException {
        EMFMarkerUtil.addMarkerFor(eObject, message, 2);
    }

    @WrapToScript
    public void addInfoMarker(@ScriptParameter(name="eObject") EObject eObject, @ScriptParameter(name="message") String message) throws CoreException {
        EMFMarkerUtil.addMarkerFor(eObject, message, 0);
    }

    @WrapToScript
    public void addWarningMarker(@ScriptParameter(name="eObject") EObject eObject, @ScriptParameter(name="message") String message) throws CoreException {
        EMFMarkerUtil.addMarkerFor(eObject, message, 1);
    }

    protected IEditorPart getCurrentEditorPart() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        class ActiveEditorRef {
            public IEditorPart activeEditorPart = null;

            ActiveEditorRef() {
            }
        }
        ActiveEditorRef activeEditorRef = new ActiveEditorRef();
        Display display = workbench.getDisplay();
        display.syncExec(() -> {
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            if (window != null && window.getActivePage() != null && window.getActivePage().getActiveEditor() != null) {
                activeEditorRef.activeEditorPart = window.getActivePage().getActiveEditor();
            }
        });
        return activeEditorRef.activeEditorPart;
    }

    @WrapToScript
    public void save(@ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null", name="target") Object target) {
        Resource toSave = null;
        if (target instanceof EObject) {
            EObject eObject = (EObject)target;
            toSave = eObject.eResource();
        } else if (target instanceof Resource) {
            toSave = (Resource)target;
        }
        if (toSave != null) {
            try {
                toSave.save(null);
            }
            catch (IOException e) {
                e.printStackTrace();
                ((UIModule)this.getEnvironment().getModule(UIModule.class)).showErrorDialog("Error", e.getMessage());
                return;
            }
        } else {
            this.save();
        }
    }

    public void save() {
        this.getCurrentEditorPart().doSave((IProgressMonitor)new NullProgressMonitor());
    }

    protected EditingDomain getEditingDomain() {
        IEditorPart currentEditorPart = this.getCurrentEditorPart();
        if (currentEditorPart != null) {
            Object domain = currentEditorPart.getAdapter(EditingDomain.class);
            if (domain instanceof EditingDomain) {
                return (EditingDomain)domain;
            }
            domain = AdapterManager.getDefault().getAdapter((Object)currentEditorPart, EditingDomain.class);
            if (domain instanceof EditingDomain) {
                return (EditingDomain)domain;
            }
            if (currentEditorPart instanceof IEditingDomainProvider) {
                return ((IEditingDomainProvider)currentEditorPart).getEditingDomain();
            }
        } else {
            Logger.warning((String)"org.eclipse.ease.modules.modeling", (String)"Unable to retreive editing domain. There is not opened editor");
        }
        return null;
    }

    @WrapToScript
    public static Collection<Object[]> getUsages(@ScriptParameter(name="eObject") EObject eObject) {
        if (eObject == null) {
            return Collections.emptyList();
        }
        ECrossReferenceAdapter crossReferencer = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)eObject);
        if (crossReferencer == null) {
            crossReferencer = new ECrossReferenceAdapter();
            if (eObject.eResource() != null) {
                if (eObject.eResource().getResourceSet() != null) {
                    crossReferencer.setTarget((Notifier)eObject.eResource().getResourceSet());
                } else {
                    crossReferencer.setTarget((Notifier)eObject.eResource());
                }
            } else {
                crossReferencer.setTarget((Notifier)eObject);
            }
        }
        Collection result = crossReferencer.getInverseReferences(eObject, true);
        return Collections2.transform((Collection)result, arg0 -> {
            Object[] setting = new Object[2];
            setting[1] = arg0.getEStructuralFeature();
            setting[0] = arg0.getEObject();
            return setting;
        });
    }

    protected ResourceSet getResourceSet() {
        EditingDomain editingDomain = this.getEditingDomain();
        if (editingDomain != null) {
            return editingDomain.getResourceSet();
        }
        return null;
    }

    public void runOperation(@ScriptParameter(name="operation") Runnable operation) {
        this.runOperation(operation, "Script Operation");
    }

    @WrapToScript
    public void runOperation(@ScriptParameter(name="operation") Runnable operation, @ScriptParameter(name="name", defaultValue="Script Operation") String operationName) {
        EditingDomain domain = this.getEditingDomain();
        if (domain instanceof TransactionalEditingDomain) {
            ((TransactionalEditingDomain)domain).getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)new RunnableTransactionalCommandWrapper((TransactionalEditingDomain)domain, operationName, null, operation)));
        } else if (domain != null) {
            ChangeRecorder recorder = new ChangeRecorder();
            domain.getCommandStack().execute((Command)new RunnableCommandWrapper(operation, domain.getResourceSet(), recorder));
            recorder.dispose();
        } else {
            operation.run();
        }
    }

    @WrapToScript
    public Object[] selectFromList(List<? extends Object> inputs) {
        return DialogModule.selectFromList(inputs.toArray(), (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof EObject) {
                    return EcoreModule.this.getLabelProvider((EObject)element).getText(element);
                }
                return element.toString();
            }
        });
    }

    @WrapToScript
    public String ePrint(EObject target) {
        IItemLabelProvider labelProvider = this.getLabelProvider(target);
        if (labelProvider != null) {
            return labelProvider.getText((Object)target);
        }
        return "[ERRO] Unable to print this EObject";
    }

    private IItemLabelProvider getLabelProvider(EObject target) {
        IItemLabelProvider labelProvider = (IItemLabelProvider)adapter.adapt((Notifier)target, IItemLabelProvider.class);
        return labelProvider;
    }

    public ICodeFactory getCodeFactory() {
        return ScriptService.getCodeFactory((IScriptEngine)this.getScriptEngine());
    }

    protected static class RunnableCommandWrapper
    extends ChangeCommand {
        private final Runnable operation;

        public RunnableCommandWrapper(Runnable operation, ResourceSet set, ChangeRecorder recorder) {
            super(recorder, (Notifier)set);
            this.operation = operation;
        }

        protected void doExecute() {
            this.operation.run();
        }
    }

    protected static class RunnableTransactionalCommandWrapper
    extends AbstractTransactionalCommand {
        private final Runnable operation;

        public RunnableTransactionalCommandWrapper(TransactionalEditingDomain domain, String label, List affectedFiles, Runnable operation) {
            super(domain, label, affectedFiles);
            this.operation = operation;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.operation.run();
            return CommandResult.newOKCommandResult();
        }
    }
}

