/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.javascript.rhino;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.security.AccessController;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.ease.AbstractScriptEngine;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Script;
import org.eclipse.ease.ScriptExecutionException;
import org.eclipse.ease.classloader.EaseClassLoader;
import org.eclipse.ease.debugging.IScriptDebugFrame;
import org.eclipse.ease.debugging.ScriptDebugFrame;
import org.eclipse.ease.debugging.ScriptStackTrace;
import org.eclipse.ease.lang.javascript.JavaScriptHelper;
import org.eclipse.ease.lang.javascript.rhino.ObservingContextFactory;
import org.eclipse.ease.tools.RunnableWithResult;
import org.eclipse.swt.widgets.Display;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;

public class RhinoScriptEngine
extends AbstractScriptEngine {
    private static final EaseClassLoader CLASSLOADER = new EaseClassLoader();
    public static final String ENGINE_ID = "org.eclipse.ease.javascript.rhino";
    private ScriptableObject fScope;
    private Context fContext;
    private int fOptimizationLevel = 9;
    private ScriptStackTrace fExceptionStackTrace = null;

    static {
        ContextFactory.initGlobal((ContextFactory)new ObservingContextFactory());
        AccessController.doPrivileged(() -> {
            ContextFactory.getGlobal().initApplicationClassLoader((ClassLoader)CLASSLOADER);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Context getContext() {
        Context context = Context.getCurrentContext();
        if (context == null) {
            ContextFactory contextFactory = ContextFactory.getGlobal();
            synchronized (contextFactory) {
                context = Context.enter();
            }
        }
        return context;
    }

    public RhinoScriptEngine() {
        super("Rhino");
    }

    protected RhinoScriptEngine(String name) {
        super(name);
    }

    public void setOptimizationLevel(int level) {
        this.fOptimizationLevel = level;
    }

    protected synchronized void setupEngine() {
        this.fContext = RhinoScriptEngine.getContext();
        this.fContext.setGeneratingDebug(false);
        this.fContext.setOptimizationLevel(this.fOptimizationLevel);
        this.fContext.setDebugger(null, null);
        this.fScope = new ImporterTopLevel(this.fContext);
        this.fContext.setGenerateObserverCount(true);
        this.fContext.setInstructionObserverThreshold(10);
        try {
            Context.class.getDeclaredField("VERSION_1_8");
            this.fContext.setLanguageVersion(180);
        }
        catch (Exception e) {
            this.fContext.setLanguageVersion(170);
        }
    }

    protected synchronized void teardownEngine() {
        this.fContext.setDebugger(null, null);
        Context.exit();
        this.fContext = null;
        this.fScope = null;
        CLASSLOADER.unregisterEngine((IScriptEngine)this);
    }

    protected Object execute(final Script script, final Object reference, final String fileName, boolean uiThread) throws Throwable {
        if (uiThread) {
            RunnableWithResult<Object> runnable = new RunnableWithResult<Object>(){

                public void runWithTry() throws Throwable {
                    RhinoScriptEngine.getContext().initStandardObjects(RhinoScriptEngine.this.fScope);
                    this.setResult(RhinoScriptEngine.this.internalExecute(script, reference, fileName));
                }
            };
            Display.getDefault().syncExec((Runnable)runnable);
            return runnable.getResultFromTry();
        }
        return this.internalExecute(script, reference, fileName);
    }

    private Object internalExecute(Script script, Object reference, String fileName) throws Throwable {
        Object result;
        block25: {
            block24: {
                ((ObservingContextFactory)ContextFactory.getGlobal()).cancelTerminate(RhinoScriptEngine.getContext());
                try {
                    if (script.getCommand() instanceof NativeFunction) {
                        result = ((NativeFunction)script.getCommand()).call(RhinoScriptEngine.getContext(), (Scriptable)this.fScope, (Scriptable)this.fScope, ScriptRuntime.emptyArgs);
                    } else if (script.getCommand() instanceof org.mozilla.javascript.Script) {
                        result = ((org.mozilla.javascript.Script)script.getCommand()).exec(RhinoScriptEngine.getContext(), (Scriptable)this.fScope);
                    } else {
                        InputStreamReader codeReader = new InputStreamReader(script.getCodeStream());
                        result = RhinoScriptEngine.getContext().evaluateReader((Scriptable)this.fScope, (Reader)codeReader, fileName, 1, null);
                        codeReader.close();
                    }
                    if (result != null && !(result instanceof Undefined)) break block24;
                    return null;
                }
                catch (RhinoException e) {
                    this.fExceptionStackTrace = this.getStackTrace().clone();
                    if (this.fExceptionStackTrace.isEmpty() || script != null && !script.equals((Object)((IScriptDebugFrame)this.fExceptionStackTrace.get(0)).getScript())) {
                        this.fExceptionStackTrace.add(0, (Object)new ScriptDebugFrame(script, e.lineNumber(), 1));
                    }
                    String message = e.getMessage();
                    String errorName = "Error";
                    Throwable cause = null;
                    if (e instanceof WrappedException) {
                        Throwable wrapped = ((WrappedException)e).getWrappedException();
                        if (wrapped instanceof ScriptExecutionException) {
                            throw wrapped;
                        }
                        if (wrapped != null) {
                            message = wrapped.getMessage();
                            errorName = "JavaError";
                            cause = wrapped;
                        }
                    } else if (e instanceof EcmaError) {
                        message = ((EcmaError)e).getErrorMessage();
                        errorName = ((EcmaError)e).getName();
                    } else if (e instanceof JavaScriptException) {
                        Object value = ((JavaScriptException)e).getValue();
                        if (value instanceof NativeJavaObject) {
                            Object unwrapped = ((NativeJavaObject)value).unwrap();
                            if (unwrapped instanceof Throwable) {
                                message = ((Throwable)unwrapped).getMessage();
                                errorName = "JavaError";
                                cause = (Throwable)unwrapped;
                            } else {
                                message = unwrapped != null ? unwrapped.toString() : null;
                                errorName = "ScriptException";
                            }
                        } else {
                            message = ((JavaScriptException)e).getValue() != null ? ((JavaScriptException)e).getValue().toString() : null;
                            errorName = "ScriptException";
                        }
                    } else if (e instanceof EvaluatorException) {
                        errorName = "SyntaxError";
                    } else {
                        message = "Error running script";
                    }
                    throw new ScriptExecutionException(message, e.columnNumber(), e.lineSource(), errorName, this.getExceptionStackTrace(), cause);
                }
            }
            if (result instanceof NativeJavaObject) {
                return ((NativeJavaObject)result).unwrap();
            }
            if (!result.getClass().getName().equals("org.mozilla.javascript.InterpretedFunction")) break block25;
            return null;
        }
        return result;
    }

    public ScriptStackTrace getExceptionStackTrace() {
        return this.fExceptionStackTrace;
    }

    public void terminateCurrent() {
        ((ObservingContextFactory)ContextFactory.getGlobal()).terminate(this.fContext);
    }

    public synchronized void registerJar(URL url) {
        CLASSLOADER.registerURL((IScriptEngine)this, url);
    }

    protected Object internalGetVariable(String name) {
        return RhinoScriptEngine.getVariable((Scriptable)this.fScope, name);
    }

    protected Map<String, Object> internalGetVariables() {
        return RhinoScriptEngine.getVariables((Scriptable)this.fScope);
    }

    public static Map<String, Object> getVariables(Scriptable scope) {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        Object[] objectArray = scope.getIds();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            Object value = RhinoScriptEngine.getVariable(scope, key.toString());
            if (value == null || !value.getClass().getName().startsWith("org.mozilla.javascript.gen")) {
                result.put(key.toString(), value);
            }
            ++n2;
        }
        Scriptable parent = scope.getParentScope();
        if (parent != null) {
            result.putAll(RhinoScriptEngine.getVariables(parent));
        }
        return result;
    }

    public static Object getVariable(Scriptable scope, String name) {
        Object value = scope.get(name, scope);
        if (value instanceof NativeJavaObject) {
            return ((NativeJavaObject)value).unwrap();
        }
        return value;
    }

    protected boolean internalHasVariable(String name) {
        Object value = this.fScope.get(name, (Scriptable)this.fScope);
        return !Scriptable.NOT_FOUND.equals(value);
    }

    protected void internalSetVariable(String name, Object content) {
        if (!JavaScriptHelper.isSaveName((String)name)) {
            throw new RuntimeException("\"" + name + "\" is not a valid JavaScript variable name");
        }
        ScriptableObject scope = this.fScope;
        Object jsOut = this.internaljavaToJS(content, (Scriptable)scope);
        scope.put(name, (Scriptable)scope, jsOut);
    }

    protected Object internalRemoveVariable(String name) {
        Object result = this.getVariable(name);
        this.fScope.delete(name);
        return result;
    }

    private Object internaljavaToJS(Object value, Scriptable scope) {
        Object result = null;
        result = this.isPrimitiveType(value) || value instanceof Scriptable ? value : (value instanceof Character ? String.valueOf(((Character)value).charValue()) : RhinoScriptEngine.getContext().getWrapFactory().wrap(RhinoScriptEngine.getContext(), scope, value, null));
        return result;
    }

    private boolean isPrimitiveType(Object value) {
        return value instanceof String || value instanceof Number || value instanceof Boolean;
    }

    public String getSaveVariableName(String name) {
        return JavaScriptHelper.getSaveName((String)name);
    }

    public ScriptableObject getScope() {
        return this.fScope;
    }
}

