/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.javascript.rhino.debugger;

import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.ease.IDebugEngine;
import org.eclipse.ease.debugging.EventDispatchJob;
import org.eclipse.ease.debugging.IEventProcessor;
import org.eclipse.ease.debugging.ScriptStackTrace;
import org.eclipse.ease.lang.javascript.rhino.RhinoScriptEngine;
import org.eclipse.ease.lang.javascript.rhino.debugger.LineNumberDebugger;
import org.eclipse.ease.lang.javascript.rhino.debugger.RhinoDebugger;
import org.eclipse.ease.lang.javascript.rhino.debugger.model.RhinoDebugTarget;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.debug.Debugger;

public class RhinoDebuggerEngine
extends RhinoScriptEngine
implements IDebugEngine {
    public static final String ENGINE_ID = "org.eclipse.ease.javascript.rhinoDebugger";
    private RhinoDebugger fDebugger = new LineNumberDebugger(this);

    public RhinoDebuggerEngine() {
        super("Rhino Debugger");
    }

    protected synchronized void setupEngine() {
        super.setupEngine();
        Context context = RhinoDebuggerEngine.getContext();
        context.setOptimizationLevel(-1);
        context.setGeneratingDebug(true);
        context.setGeneratingSource(true);
        context.setDebugger((Debugger)this.fDebugger, null);
    }

    public void setOptimizationLevel(int level) {
    }

    public void setupDebugger(ILaunch launch, boolean suspendOnStartup, boolean suspendOnScriptLoad, boolean showDynamicCode) {
        RhinoDebugTarget debugTarget = new RhinoDebugTarget(launch, suspendOnStartup, suspendOnScriptLoad, showDynamicCode);
        launch.addDebugTarget((IDebugTarget)debugTarget);
        this.fDebugger = new RhinoDebugger(this, showDynamicCode);
        EventDispatchJob dispatcher = new EventDispatchJob((IEventProcessor)debugTarget, (IEventProcessor)this.fDebugger);
        debugTarget.setDispatcher(dispatcher);
        this.fDebugger.setDispatcher(dispatcher);
        dispatcher.schedule();
    }

    public ScriptStackTrace getStackTrace() {
        return this.fDebugger.getStacktrace();
    }

    public ScriptStackTrace getExceptionStackTrace() {
        if (this.fDebugger.getExceptionStacktrace() == null || this.fDebugger.getExceptionStacktrace().isEmpty()) {
            return super.getExceptionStackTrace();
        }
        return this.fDebugger.getExceptionStacktrace();
    }
}

