/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.charting.charts;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.ease.tools.RunnableWithResult;
import org.eclipse.nebula.visualization.xygraph.dataprovider.CircularBufferDataProvider;
import org.eclipse.nebula.visualization.xygraph.dataprovider.IDataProvider;
import org.eclipse.nebula.visualization.xygraph.dataprovider.ISample;
import org.eclipse.nebula.visualization.xygraph.dataprovider.Sample;
import org.eclipse.nebula.visualization.xygraph.figures.Annotation;
import org.eclipse.nebula.visualization.xygraph.figures.Axis;
import org.eclipse.nebula.visualization.xygraph.figures.PlotArea;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.ZoomType;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;

public class Chart
extends Composite {
    private final XYGraph fXYGraph;
    private final List<Trace> fTraces = new ArrayList<Trace>();
    private final List<CircularBufferDataProvider> fTraceDataProviders = new ArrayList<CircularBufferDataProvider>();
    private boolean fPerformAutoScale = true;
    private int fIndex = -1;
    private Trace fCurrentTrace;
    private int fSeriesCounter = 1;

    public Chart(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        GridData gd = new GridData(4, 4, true, true);
        this.setLayout((Layout)layout);
        Canvas myCanvas = new Canvas((Composite)this, style);
        myCanvas.setLayoutData((Object)gd);
        LightweightSystem lws = new LightweightSystem(myCanvas);
        this.fXYGraph = new XYGraph();
        this.fXYGraph.setTitle("Chart");
        this.fXYGraph.primaryXAxis.setShowMajorGrid(true);
        this.fXYGraph.primaryYAxis.setShowMajorGrid(true);
        this.fXYGraph.setZoomType(ZoomType.DYNAMIC_ZOOM);
        this.fXYGraph.getPlotArea().addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent me) {
            }

            public void mouseReleased(MouseEvent me) {
            }

            public void mouseDoubleClicked(MouseEvent me) {
                Chart.this.fXYGraph.performAutoScale();
            }
        });
        lws.setContents((IFigure)this.fXYGraph);
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(org.eclipse.swt.events.MouseEvent e) {
                IFigure figureUnderMouse = Chart.this.fXYGraph.findFigureAt(e.x, e.y, new TreeSearch(){

                    public boolean prune(IFigure figure) {
                        return false;
                    }

                    public boolean accept(IFigure figure) {
                        return figure instanceof Axis || figure instanceof PlotArea;
                    }
                });
                if (figureUnderMouse instanceof Axis) {
                    Axis axis;
                    double valuePosition = axis.getPositionValue((axis = (Axis)figureUnderMouse).isHorizontal() ? e.x : e.y, false);
                    axis.zoomInOut(valuePosition, (double)e.count * 0.1 / 3.0);
                } else if (figureUnderMouse instanceof PlotArea) {
                    PlotArea plotArea = (PlotArea)figureUnderMouse;
                    plotArea.zoomInOut(true, true, e.x, e.y, (double)e.count * 0.1 / 3.0);
                }
            }
        });
    }

    private void getTraceIndex(String traceName) {
        boolean findTrace = false;
        this.fIndex = 0;
        for (Trace trace : this.fTraces) {
            if (trace.getName().equals(traceName)) {
                findTrace = true;
                break;
            }
            ++this.fIndex;
        }
        if (!findTrace) {
            CircularBufferDataProvider newTraceDataProvider = new CircularBufferDataProvider(false);
            newTraceDataProvider.setBufferSize(1000);
            this.fTraceDataProviders.add(newTraceDataProvider);
            Trace currentTrace = new Trace(traceName, this.fXYGraph.primaryXAxis, this.fXYGraph.primaryYAxis, (IDataProvider)newTraceDataProvider);
            currentTrace.setTraceType(Trace.TraceType.SOLID_LINE);
            currentTrace.setPointStyle(Trace.PointStyle.XCROSS);
            currentTrace.setPointSize(5);
            this.fTraces.add(currentTrace);
            this.fXYGraph.addTrace(currentTrace);
        }
    }

    public Trace plot(final double x, final double y) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (Chart.this.fIndex == -1) {
                    StringBuilder stringBuilder = new StringBuilder("Series ");
                    Chart chart = Chart.this;
                    int n = chart.fSeriesCounter;
                    chart.fSeriesCounter = n + 1;
                    Chart.this.getTraceIndex(stringBuilder.append(Integer.toString(n)).toString());
                }
                Chart.this.plotPoint(x, y);
            }
        });
        return this.fTraces.get(this.fIndex);
    }

    private void plotPoint(double x, double y) {
        this.fTraceDataProviders.get(this.fIndex).addSample((ISample)new Sample(x, y));
        if (this.fPerformAutoScale) {
            this.fXYGraph.performAutoScale();
        }
    }

    private void setStyle(Trace trace, String format) {
        boolean doubleLine = false;
        char[] cArray = format.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            switch (ch) {
                case 'r': {
                    trace.setTraceColor(XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_RED));
                    break;
                }
                case 'g': {
                    trace.setTraceColor(XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_GREEN));
                    break;
                }
                case 'b': {
                    trace.setTraceColor(XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_BLUE));
                    break;
                }
                case 'c': {
                    trace.setTraceColor(XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_CYAN));
                    break;
                }
                case 'm': {
                    trace.setTraceColor(XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_PURPLE));
                    break;
                }
                case 'y': {
                    trace.setTraceColor(XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_YELLOW));
                    break;
                }
                case 'k': {
                    trace.setTraceColor(XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_BLACK));
                    break;
                }
                case 'w': {
                    trace.setTraceColor(XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_WHITE));
                    break;
                }
                case 'o': {
                    trace.setPointStyle(Trace.PointStyle.CIRCLE);
                    break;
                }
                case 'x': {
                    trace.setPointStyle(Trace.PointStyle.XCROSS);
                    break;
                }
                case '+': {
                    trace.setPointStyle(Trace.PointStyle.CROSS);
                    break;
                }
                case 's': {
                    trace.setPointStyle(Trace.PointStyle.SQUARE);
                    break;
                }
                case 'f': {
                    trace.setPointStyle(Trace.PointStyle.FILLED_SQUARE);
                    break;
                }
                case 'd': {
                    trace.setPointStyle(Trace.PointStyle.DIAMOND);
                    break;
                }
                case 'v': {
                    trace.setPointStyle(Trace.PointStyle.TRIANGLE);
                    break;
                }
                case 'p': {
                    trace.setPointStyle(Trace.PointStyle.POINT);
                    break;
                }
                case '-': {
                    if (doubleLine) {
                        trace.setTraceType(Trace.TraceType.DASH_LINE);
                    } else {
                        trace.setTraceType(Trace.TraceType.SOLID_LINE);
                    }
                    doubleLine = true;
                    break;
                }
                case ':': {
                    trace.setTraceType(Trace.TraceType.DOT_LINE);
                    break;
                }
                case '.': {
                    trace.setTraceType(Trace.TraceType.DASHDOT_LINE);
                    break;
                }
                case '#': {
                    trace.setTraceType(Trace.TraceType.POINT);
                }
            }
            Pattern regex = Pattern.compile("(\\d+)");
            Matcher regexMatcher = regex.matcher(format);
            if (regexMatcher.find()) {
                trace.setPointSize(Integer.parseInt(regexMatcher.group(1)));
            }
            ++n2;
        }
    }

    public XYGraph setPlotTitle(final String title) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Chart.this.fXYGraph.setTitle(title);
            }
        });
        return this.fXYGraph;
    }

    public Axis setXLabel(final String title) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ((Chart)Chart.this).fXYGraph.primaryXAxis.setTitle(title);
            }
        });
        return this.fXYGraph.primaryXAxis;
    }

    public Axis setYLabel(final String title) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ((Chart)Chart.this).fXYGraph.primaryYAxis.setTitle(title);
            }
        });
        return this.fXYGraph.primaryYAxis;
    }

    public void setAxisRange(final double[] xrange, final double[] yrange) {
        if (xrange.length != 2 || yrange.length != 2) {
            throw new IndexOutOfBoundsException();
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ((Chart)Chart.this).fXYGraph.primaryXAxis.setRange(xrange[0], xrange[1]);
                ((Chart)Chart.this).fXYGraph.primaryYAxis.setRange(yrange[0], yrange[1]);
            }
        });
    }

    public void showGrid(final boolean showGrid) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ((Chart)Chart.this).fXYGraph.primaryXAxis.setShowMajorGrid(showGrid);
                ((Chart)Chart.this).fXYGraph.primaryYAxis.setShowMajorGrid(showGrid);
            }
        });
    }

    public void setAutoScale(boolean performAutoScale) {
        this.fPerformAutoScale = performAutoScale;
    }

    public void zoom(final String zoomType) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Chart.this.fXYGraph.setZoomType(ZoomType.valueOf((String)zoomType));
            }
        });
    }

    public void export(final Object object, final boolean overwrite) throws Throwable {
        RunnableWithResult<Object> runnable = new RunnableWithResult<Object>(){

            public void runWithTry() throws Throwable {
                ImageLoader loader = new ImageLoader();
                loader.data = new ImageData[]{Chart.this.fXYGraph.getImage().getImageData()};
                boolean done = true;
                if (object != null) {
                    Object file;
                    MessageBox mb = new MessageBox(Display.getDefault().getShells()[0], 200);
                    mb.setText("Warning");
                    if (object instanceof IFile) {
                        file = (IFile)object;
                        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                        loader.save((OutputStream)outStream, 5);
                        ByteArrayInputStream stream = new ByteArrayInputStream(outStream.toByteArray());
                        if (file.exists()) {
                            if (!overwrite) {
                                mb.setMessage(String.valueOf(file.getName()) + " already exists. Do you want to replace it?");
                                boolean bl = done = mb.open() == 64;
                            }
                            if (done) {
                                file.setContents((InputStream)stream, 0, null);
                            }
                        } else {
                            file.create((InputStream)stream, 0, null);
                        }
                        file.getParent().refreshLocal(1, null);
                    } else if (object instanceof File) {
                        file = (File)object;
                        if (((File)file).exists() && !overwrite) {
                            mb.setMessage(String.valueOf(((File)file).getName()) + " already exists. Do you want to replace it?");
                            boolean bl = done = mb.open() == 64;
                        }
                        if (done) {
                            loader.save(((File)file).getAbsolutePath(), 5);
                        }
                    }
                }
                if (object == null || !done) {
                    FileDialog dialog = new FileDialog(Display.getDefault().getShells()[0], 8192);
                    dialog.setFilterNames(new String[]{"PNG Files", "All Files (*.*)"});
                    dialog.setFilterExtensions(new String[]{"*.png", "*.*"});
                    String path = dialog.open();
                    if (path != null && !path.equals("")) {
                        loader.save(path, 5);
                    }
                }
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        runnable.getResultFromTry();
    }

    public void setCursor(final String cursorName, final String traceName) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Trace currentTrace = null;
                for (Trace trace : Chart.this.fTraces) {
                    if (!trace.getName().equals(traceName)) continue;
                    currentTrace = trace;
                    break;
                }
                if (currentTrace == null) {
                    return;
                }
                Annotation annotation = new Annotation(cursorName, currentTrace);
                Chart.this.fXYGraph.addAnnotation(annotation);
            }
        });
    }

    public void removeCursor(final String cursorName) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Annotation currentAnnotation = null;
                for (Annotation annotation : Chart.this.fXYGraph.getPlotArea().getAnnotationList()) {
                    if (!annotation.getName().equals(cursorName)) continue;
                    currentAnnotation = annotation;
                    break;
                }
                if (currentAnnotation == null) {
                    return;
                }
                Chart.this.fXYGraph.removeAnnotation(currentAnnotation);
            }
        });
    }

    public void removeSeries(final String traceName) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                for (Trace trace : Chart.this.fTraces) {
                    if (!trace.getName().equals(traceName)) continue;
                    Chart.this.fXYGraph.removeTrace(trace);
                    Chart.this.fTraceDataProviders.remove(trace.getDataProvider());
                    Chart.this.fTraces.remove(trace);
                }
            }
        });
    }

    public void clear() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                for (Trace trace : Chart.this.fTraces) {
                    Chart.this.fXYGraph.removeTrace(trace);
                }
                Chart.this.fTraceDataProviders.clear();
                Chart.this.fTraces.clear();
                Chart.this.fSeriesCounter = 1;
            }
        });
    }

    public Trace plot(final double[] x, final double[] y) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (Chart.this.fIndex == -1) {
                    StringBuilder stringBuilder = new StringBuilder("Series ");
                    Chart chart = Chart.this;
                    int n = chart.fSeriesCounter;
                    chart.fSeriesCounter = n + 1;
                    Chart.this.getTraceIndex(stringBuilder.append(Integer.toString(n)).toString());
                }
                Chart.this.plotArray(x, y);
            }
        });
        return this.fTraces.get(this.fIndex);
    }

    private void plotArray(double[] x, double[] y) {
        this.fTraceDataProviders.get(this.fIndex).setCurrentXDataArray(x);
        this.fTraceDataProviders.get(this.fIndex).setCurrentYDataArray(y);
        if (this.fPerformAutoScale) {
            this.fXYGraph.performAutoScale();
        }
    }

    public Trace series(final String seriesName, final String format) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                String string;
                if (seriesName == null) {
                    StringBuilder stringBuilder = new StringBuilder("Series ");
                    Chart chart = Chart.this;
                    int n = chart.fSeriesCounter;
                    chart.fSeriesCounter = n + 1;
                    string = stringBuilder.append(Integer.toString(n)).toString();
                } else {
                    string = seriesName;
                }
                String traceName = string;
                Chart.this.getTraceIndex(traceName);
                Chart.this.fCurrentTrace = (Trace)Chart.this.fTraces.get(Chart.this.fIndex);
                Chart.this.setStyle(Chart.this.fCurrentTrace, format);
            }
        });
        return this.fCurrentTrace;
    }
}

