/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.platform;

import java.util.Scanner;

public class Future {
    private final Process fProcess;
    private final Exception fException;

    public Future(Process process) {
        this.fProcess = process;
        this.fException = null;
    }

    public Future(Exception exception) {
        this.fException = exception;
        this.fProcess = null;
    }

    public boolean isFinished() {
        if (this.fException == null) {
            try {
                this.fProcess.exitValue();
                return true;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                return false;
            }
        }
        return true;
    }

    public boolean join() {
        if (!this.isFinished()) {
            try {
                this.fProcess.waitFor();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.isFinished();
    }

    public int getExitCode() {
        if (this.fProcess != null) {
            return this.fProcess.exitValue();
        }
        return -1;
    }

    public String getOutput() {
        if (this.fProcess != null) {
            Scanner scanner = new Scanner(this.fProcess.getInputStream()).useDelimiter("\\A");
            return scanner.hasNext() ? scanner.next() : "";
        }
        return "";
    }

    public String getError() {
        if (this.fProcess != null) {
            Scanner scanner = new Scanner(this.fProcess.getErrorStream()).useDelimiter("\\A");
            return scanner.hasNext() ? scanner.next() : "";
        }
        if (this.fException != null) {
            return this.fException.toString();
        }
        return "";
    }
}

