/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.repository;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.eclipse.dirigible.repository.api.IMasterRepository;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.RepositoryException;
import org.eclipse.dirigible.repository.api.RepositoryFactory;
import org.eclipse.dirigible.repository.datasource.DataSourceFacade;
import org.eclipse.dirigible.repository.datasource.WrappedDataSource;
import org.eclipse.dirigible.repository.ext.utils.RequestUtils;
import org.eclipse.dirigible.repository.logging.Logger;

public class RepositoryFacade {
    private static final String PARAM_RECREATE = "recreate";
    private static final String PARAM_USER = "user";
    private static final String PARAM_DATASOURCE = "datasource";
    private static final String PARAM_GIT_TARGET_FOLDER = "masterRepositoryGitTarget";
    private static final String PARAM_GIT_LOCATION = "masterRepositoryGitLocation";
    private static final String PARAM_GIT_USER = "masterRepositoryGitUser";
    private static final String PARAM_GIT_PASSWORD = "masterRepositoryGitPassword";
    private static final String PARAM_GIT_BRANCH = "masterRepositoryGitBranch";
    private static final Logger logger = Logger.getLogger(RepositoryFacade.class);
    private static final String LOCAL_DB_ACTION = "create";
    private static final String LOCAL_DB_NAME = "derby";
    public static final String REPOSITORY = "repository-instance";
    private static final String MASTER_REPOSITORY = "master-repository-instance";
    private static RepositoryFacade instance;
    private static DataSource localDataSource;
    private WrappedDataSource dataSource;

    private RepositoryFacade() {
    }

    public static RepositoryFacade getInstance() {
        if (instance == null) {
            instance = new RepositoryFacade();
        }
        return instance;
    }

    public IRepository getRepository(HttpServletRequest request) throws RepositoryException {
        IRepository repository = this.getRepositoryInstance(request);
        if (repository != null) {
            return repository;
        }
        try {
            DataSource defaultDataSource = DataSourceFacade.getInstance().getDataSource(request);
            String user = RepositoryFacade.getUser(request);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put(PARAM_DATASOURCE, defaultDataSource);
            parameters.put(PARAM_USER, user);
            parameters.put(PARAM_RECREATE, Boolean.FALSE);
            parameters.put(PARAM_GIT_TARGET_FOLDER, System.getProperty(PARAM_GIT_TARGET_FOLDER));
            parameters.put(PARAM_GIT_LOCATION, System.getProperty(PARAM_GIT_LOCATION));
            parameters.put(PARAM_GIT_USER, System.getProperty(PARAM_GIT_USER));
            parameters.put(PARAM_GIT_PASSWORD, System.getProperty(PARAM_GIT_PASSWORD));
            parameters.put(PARAM_GIT_BRANCH, System.getProperty(PARAM_GIT_BRANCH));
            repository = RepositoryFactory.createRepository(parameters);
            this.saveRepositoryInstance(request, repository);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException((Throwable)e);
        }
        return repository;
    }

    public IMasterRepository getMasterRepository(HttpServletRequest request) throws RepositoryException {
        IMasterRepository repository;
        block4: {
            repository = this.getMasterRepositoryInstance(request);
            if (repository != null) {
                return repository;
            }
            try {
                DataSource defaultDataSource = DataSourceFacade.getInstance().getDataSource(request);
                String user = RepositoryFacade.getUser(request);
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put(PARAM_DATASOURCE, defaultDataSource);
                parameters.put(PARAM_USER, user);
                parameters.put(PARAM_RECREATE, Boolean.FALSE);
                repository = RepositoryFactory.createMasterRepository(parameters);
                if (repository != null) break block4;
                return null;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RepositoryException((Throwable)e);
            }
        }
        this.saveMasterRepositoryInstance(request, repository);
        return repository;
    }

    public static String getUser(HttpServletRequest request) {
        return RequestUtils.getUser((HttpServletRequest)request);
    }

    private IRepository getRepositoryInstance(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        try {
            return (IRepository)request.getSession().getAttribute(REPOSITORY);
        }
        catch (IllegalStateException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private IMasterRepository getMasterRepositoryInstance(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        try {
            return (IMasterRepository)request.getSession().getAttribute(MASTER_REPOSITORY);
        }
        catch (IllegalStateException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void saveRepositoryInstance(HttpServletRequest request, IRepository repository) {
        if (request == null) {
            return;
        }
        request.getSession().setAttribute(REPOSITORY, (Object)repository);
    }

    private void saveMasterRepositoryInstance(HttpServletRequest request, IMasterRepository repository) {
        if (request == null) {
            return;
        }
        request.getSession().setAttribute(MASTER_REPOSITORY, (Object)repository);
    }
}

