/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.impl;

import java.net.URI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dirigible.ide.workspace.impl.Container;
import org.eclipse.dirigible.ide.workspace.impl.Messages;
import org.eclipse.dirigible.ide.workspace.impl.Project;
import org.eclipse.dirigible.ide.workspace.impl.Workspace;

public class WorkspaceRoot
extends Container
implements IWorkspaceRoot {
    private static final String ONLY_PROJECTS_SHOULD_BE_CHILDREN_OF_THE_ROOT = Messages.WorkspaceRoot_ONLY_PROJECTS_SHOULD_BE_CHILDREN_OF_THE_ROOT;
    private static final String THE_PROJECT_PATH_MUST_HAVE_EXACTLY_ONE_SEGMENT = Messages.WorkspaceRoot_THE_PROJECT_PATH_MUST_HAVE_EXACTLY_ONE_SEGMENT;

    public WorkspaceRoot(IPath path, Workspace workspace) {
        super(path, workspace);
    }

    public void delete(boolean deleteContent, boolean force, IProgressMonitor monitor) throws CoreException {
        int flags = (deleteContent ? 4 : 8) | (force ? 1 : 0);
        this.delete(flags, monitor);
    }

    public IContainer[] findContainersForLocation(IPath arg0) {
        throw new UnsupportedOperationException();
    }

    public IContainer[] findContainersForLocationURI(URI arg0) {
        throw new UnsupportedOperationException();
    }

    public IContainer[] findContainersForLocationURI(URI arg0, int arg1) {
        throw new UnsupportedOperationException();
    }

    public IFile[] findFilesForLocation(IPath arg0) {
        throw new UnsupportedOperationException();
    }

    public IFile[] findFilesForLocationURI(URI arg0) {
        throw new UnsupportedOperationException();
    }

    public IFile[] findFilesForLocationURI(URI arg0, int arg1) {
        throw new UnsupportedOperationException();
    }

    public IContainer getContainerForLocation(IPath location) {
        IWorkspaceRoot root = this.workspace.getRoot();
        if (!root.getLocation().isPrefixOf(location)) {
            return null;
        }
        IResource resource = this.workspace.newResource(location);
        if (resource instanceof IContainer) {
            return (IContainer)resource;
        }
        return null;
    }

    public IFile getFileForLocation(IPath location) {
        IResource resource = this.workspace.newResource(location);
        if (resource instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    public IProject getProject(String name) {
        IPath resourcePath = this.path.append(name);
        if (resourcePath.segmentCount() != 1) {
            throw new IllegalArgumentException(THE_PROJECT_PATH_MUST_HAVE_EXACTLY_ONE_SEGMENT);
        }
        Project project = new Project(resourcePath, this.workspace);
        return project;
    }

    public IProject[] getProjects() {
        return this.getProjects(0);
    }

    public IProject[] getProjects(int memeberFlags) {
        try {
            IResource[] children = this.members();
            IProject[] projects = new IProject[children.length];
            try {
                System.arraycopy(children, 0, projects, 0, children.length);
            }
            catch (ArrayStoreException ex) {
                throw new IllegalStateException(ONLY_PROJECTS_SHOULD_BE_CHILDREN_OF_THE_ROOT, ex);
            }
            return projects;
        }
        catch (CoreException coreException) {
            return new IProject[0];
        }
    }
}

