/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleAdapterUtil;
import org.eclipse.rap.rwt.internal.theme.ThemeAdapter;
import org.eclipse.rap.rwt.internal.theme.ThemeManagerException;
import org.eclipse.rap.rwt.internal.util.ClassInstantiationException;
import org.eclipse.rap.rwt.internal.util.ClassUtil;
import org.eclipse.swt.internal.widgets.controlkit.ControlThemeAdapterImpl;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public final class ThemeAdapterManager {
    private final Map<Class, ThemeAdapter> themeAdapters = new HashMap<Class, ThemeAdapter>();

    public void reset() {
        this.themeAdapters.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThemeAdapter getThemeAdapter(Widget widget) {
        ThemeAdapter result;
        Class<?> widgetClass = widget.getClass();
        Map<Class, ThemeAdapter> map = this.themeAdapters;
        synchronized (map) {
            result = this.themeAdapters.get(widgetClass);
            if (result == null) {
                ThemeAdapter adapter = ThemeAdapterManager.findThemeAdapter(widgetClass);
                this.themeAdapters.put(widgetClass, adapter);
                result = adapter;
            }
        }
        ThemeAdapterManager.ensureThemeAdapterWasFound(widgetClass, result);
        return result;
    }

    private static ThemeAdapter findThemeAdapter(Class widgetClass) {
        ThemeAdapter result = null;
        Class superClass = widgetClass;
        while (!Object.class.equals((Object)superClass) && result == null) {
            result = ThemeAdapterManager.loadThemeAdapter(superClass);
            if (result != null) continue;
            superClass = superClass.getSuperclass();
        }
        return result;
    }

    private static ThemeAdapter loadThemeAdapter(Class clazz) {
        ThemeAdapter result = null;
        if (clazz == Control.class) {
            result = new ControlThemeAdapterImpl();
        } else {
            String className = LifeCycleAdapterUtil.getSimpleClassName(clazz);
            String[] variants = LifeCycleAdapterUtil.getKitPackageVariants(clazz);
            int i = 0;
            while (result == null && i < variants.length) {
                StringBuilder buffer = new StringBuilder();
                buffer.append(variants[i]);
                buffer.append(".");
                buffer.append(className);
                buffer.append("ThemeAdapter");
                String classToLoad = buffer.toString();
                ClassLoader loader = clazz.getClassLoader();
                result = ThemeAdapterManager.loadThemeAdapter(classToLoad, loader);
                ++i;
            }
        }
        return result;
    }

    private static ThemeAdapter loadThemeAdapter(String className, ClassLoader classLoader) {
        ThemeAdapter result = null;
        try {
            result = (ThemeAdapter)ClassUtil.newInstance(classLoader, className);
        }
        catch (ClassInstantiationException classInstantiationException) {}
        return result;
    }

    private static void ensureThemeAdapterWasFound(Class widgetClass, ThemeAdapter result) {
        if (result == null) {
            String msg = "Failed to obtain theme adapter for class: " + widgetClass.getName();
            throw new ThemeManagerException(msg);
        }
    }
}

