/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.db.dao;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.dirigible.repository.db.DBBaseException;
import org.eclipse.dirigible.repository.db.DBRepository;
import org.eclipse.dirigible.repository.db.dao.DBMapper;
import org.eclipse.dirigible.repository.db.dao.DBObject;
import org.eclipse.dirigible.repository.db.dao.DBRepositoryDAO;
import org.eclipse.dirigible.repository.logging.Logger;

public class DBObjectDAO {
    private static Logger logger = Logger.getLogger(DBObjectDAO.class);
    private DBRepositoryDAO dbRepositoryDAO;

    DBObjectDAO(DBRepositoryDAO dbRepositoryDAO) {
        this.dbRepositoryDAO = dbRepositoryDAO;
    }

    public DBRepositoryDAO getDbRepositoryDAO() {
        return this.dbRepositoryDAO;
    }

    protected DBRepository getRepository() {
        return this.dbRepositoryDAO.getRepository();
    }

    protected void checkInitialized() {
        this.dbRepositoryDAO.checkInitialized();
    }

    public DBObject getObjectByPath(String path) throws DBBaseException {
        logger.debug("entering getObjectByPath");
        this.checkInitialized();
        if (path == null || "".equals(path.trim())) {
            return null;
        }
        DBObject dbObject = null;
        Object cached = this.getRepository().getCacheManager().get(path);
        if (cached != null && cached instanceof DBObject) {
            dbObject = (DBObject)cached;
        } else {
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            try {
                try {
                    connection = this.getRepository().getDbUtils().getConnection();
                    String script = this.getRepository().getDbUtils().readScript(connection, "/org/eclipse/dirigible/repository/db/sql/get_file_by_path.sql", this.getClass());
                    preparedStatement = this.getRepository().getDbUtils().getPreparedStatement(connection, script);
                    preparedStatement.setString(1, path);
                    ResultSet resultSet = null;
                    try {
                        resultSet = preparedStatement.executeQuery();
                        if (resultSet.next()) {
                            dbObject = DBMapper.dbToObject(this.getRepository(), resultSet);
                        }
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                }
                catch (SQLException e) {
                    throw new DBBaseException(e);
                }
                catch (IOException e) {
                    throw new DBBaseException(e);
                }
            }
            catch (Throwable throwable) {
                this.getRepository().getDbUtils().closeStatement(preparedStatement);
                this.getRepository().getDbUtils().closeConnection(connection);
                throw throwable;
            }
            this.getRepository().getDbUtils().closeStatement((Statement)preparedStatement);
            this.getRepository().getDbUtils().closeConnection(connection);
            this.getRepository().getCacheManager().put(path, dbObject);
        }
        logger.debug("exiting getObjectByPath");
        return dbObject;
    }
}

