/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.bridge;

import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.ide.bridge.IInjector;

public class InitParametersInjector
implements IInjector {
    private static final Logger logger = Logger.getLogger(InitParametersInjector.class.getCanonicalName());
    public static final String INIT_PARAM_RUNTIME_URL = "runtimeUrl";
    public static final String INIT_PARAM_SERVICES_URL = "servicesUrl";
    public static final String INIT_PARAM_ENABLE_ROLES = "enableRoles";
    public static final String INIT_PARAM_LOG_IN_SYSTEM_OUTPUT = "logInSystemOutput";
    public static final String INIT_PARAM_JNDI_DEFAULT_DATASOURCE = "jndiDefaultDataSource";
    public static final String INIT_PARAM_JNDI_CONNECTIVITY_CONFIGURATION = "jndiConnectivityService";
    public static final String INIT_PARAM_JNDI_MAIL_SESSION = "jndiMailService";
    public static final String INIT_PARAM_JDBC_SET_AUTO_COMMIT = "jdbcAutoCommit";
    public static final String INIT_PARAM_JDBC_MAX_CONNECTIONS_COUNT = "jdbcMaxConnectionsCount";
    public static final String INIT_PARAM_JDBC_WAIT_TIMEOUT = "jdbcWaitTimeout";
    public static final String INIT_PARAM_JDBC_WAIT_COUNT = "jdbcWaitCount";
    public static final String INIT_PARAM_REPOSITORY_PROVIDER = "repositoryProvider";
    public static final String INIT_PARAM_REPOSITORY_PROVIDER_MASTER = "repositoryProviderMaster";
    public static final String INIT_PARAM_DEFAULT_DATASOURCE_TYPE = "defaultDataSourceType";
    public static final String INIT_PARAM_DEFAULT_DATASOURCE_TYPE_JNDI = "jndi";
    public static final String INIT_PARAM_DEFAULT_DATASOURCE_TYPE_LOCAL = "local";
    public static final String INIT_PARAM_DEFAULT_MAIL_SERVICE = "mailSender";
    public static final String INIT_PARAM_DEFAULT_MAIL_SERVICE_PROVIDED = "provided";
    public static final String INIT_PARAM_DEFAULT_MAIL_SERVICE_BUILTIN = "built-in";
    public static final String HOME_URL = "homeLocation";

    @Override
    public void injectOnRequest(ServletConfig servletConfig, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Enumeration parameterNames = servletConfig.getInitParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            String parameterValue = servletConfig.getInitParameter(parameterName);
            req.getSession().setAttribute(parameterName, (Object)parameterValue);
        }
    }

    @Override
    public void injectOnStart(ServletConfig servletConfig) throws ServletException, IOException {
        Enumeration parameterNames = servletConfig.getInitParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            String parameterValue = servletConfig.getInitParameter(parameterName);
            System.getProperties().put(parameterName, parameterValue);
            logger.info(String.format("Initial Parameter set to Environment: name=%s value=%s", parameterName, parameterValue));
        }
    }

    public static String get(String key) {
        return System.getProperty(key);
    }
}

