/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import java.io.UnsupportedEncodingException;
import org.eclipse.rap.rwt.SingletonUtil;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;

public class TextTransfer
extends ByteArrayTransfer {
    private static final String TYPE_NAME = "text";
    private static final int TYPE_ID = TextTransfer.registerType("text");

    private TextTransfer() {
    }

    public static TextTransfer getInstance() {
        return SingletonUtil.getSessionInstance(TextTransfer.class);
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkText(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        transferData.data = object;
        transferData.result = 1;
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.data == null) {
            return null;
        }
        if (transferData.result != 1) {
            return null;
        }
        return transferData.data;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPE_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    boolean checkText(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    protected boolean validate(Object object) {
        return this.checkText(object);
    }

    static byte[] stringToBytes(String string) {
        byte[] bytes = null;
        try {
            bytes = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return bytes;
    }
}

