/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.repository.api.IEntity;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.runtime.registry.PathUtils;
import org.eclipse.dirigible.runtime.registry.RegistryServlet;
import org.eclipse.dirigible.runtime.repository.RepositoryFacade;
import org.eclipse.dirigible.runtime.scripting.IScriptExecutor;
import org.eclipse.dirigible.runtime.web.WebExecutor;

public class WebRegistryServlet
extends RegistryServlet {
    private static final String WEB_CONTENT = "/WebContent";
    private static final String PARAMETER_NO_HEADER_AND_FOOTER = "nohf";
    private static final String PARAMETER_LIST = "list";
    private static final long serialVersionUID = -1484072696377972535L;
    protected static final String HEADER_REF = "header.ref";
    protected static final String HEADER_HTML = "header.html";
    protected static final String FOOTER_HTML = "footer.html";
    private static final String FOOTER_REF = "footer.ref";
    protected static final String HTML_EXTENSION = ".html";
    protected static final String INDEX_HTML = "index.html";

    protected String extractRepositoryPath(HttpServletRequest request) throws IllegalArgumentException {
        String requestPath = PathUtils.extractPath((HttpServletRequest)request);
        if (request.getAttribute("sandbox") != null && ((Boolean)request.getAttribute("sandbox")).booleanValue()) {
            return "/db/dirigible/sandbox/" + RepositoryFacade.getUser((HttpServletRequest)request) + this.getContentFolder() + requestPath;
        }
        return "/db/dirigible/registry/public" + this.getContentFolder() + requestPath;
    }

    protected String getWebRegistryPath(HttpServletRequest request) throws IllegalArgumentException {
        if (request.getAttribute("sandbox") != null && ((Boolean)request.getAttribute("sandbox")).booleanValue()) {
            return "/db/dirigible/sandbox/" + RepositoryFacade.getUser((HttpServletRequest)request) + this.getContentFolder();
        }
        return "/db/dirigible/registry/public" + this.getContentFolder();
    }

    protected String getContentFolder() {
        return WEB_CONTENT;
    }

    protected byte[] buildResourceData(IEntity entity, HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean list;
        byte[] rawContent = super.buildResourceData(entity, request, response);
        boolean nohf = request.getParameter(PARAMETER_NO_HEADER_AND_FOOTER) != null;
        boolean bl = list = request.getParameter(PARAMETER_LIST) != null;
        if (list) {
            return super.buildResourceData(entity, request, response);
        }
        if (this.checkExtensions(entity) && !INDEX_HTML.equals(entity.getName().toLowerCase())) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            IResource header = entity.getParent().getResource(HEADER_HTML);
            IResource headerRef = entity.getParent().getResource(HEADER_REF);
            if (!nohf && headerRef.exists()) {
                String headerPath = new String(headerRef.getContent()).trim();
                IResource headerContent = entity.getRepository().getResource("/db/dirigible/registry/public" + this.getContentFolder() + headerPath);
                if (headerContent.exists()) {
                    outputStream.write(headerContent.getContent());
                }
            } else if (!nohf && header.exists()) {
                outputStream.write(header.getContent());
            }
            outputStream.write(this.preprocessContent(rawContent, entity));
            IResource footer = entity.getParent().getResource(FOOTER_HTML);
            IResource footerRef = entity.getParent().getResource(FOOTER_REF);
            if (!nohf && footerRef.exists()) {
                String footerPath = new String(footerRef.getContent()).trim();
                IResource footerContent = entity.getRepository().getResource("/db/dirigible/registry/public" + this.getContentFolder() + footerPath);
                if (footerContent.exists()) {
                    outputStream.write(footerContent.getContent());
                }
            } else if (!nohf && footer.exists()) {
                outputStream.write(footer.getContent());
            }
            outputStream.flush();
            return outputStream.toByteArray();
        }
        return rawContent;
    }

    protected boolean checkExtensions(IEntity entity) {
        return entity.getName().endsWith(HTML_EXTENSION);
    }

    protected byte[] preprocessContent(byte[] rawContent, IEntity entity) throws IOException {
        return rawContent;
    }

    protected byte[] buildCollectionData(boolean deep, IEntity entity, String collectionPath) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(baos);
        IResource index = entity.getParent().getResource(INDEX_HTML);
        if (!index.exists()) {
            return super.buildCollectionData(deep, entity, collectionPath);
        }
        writer.print(index.getContent());
        writer.flush();
        byte[] data = baos.toByteArray();
        return this.preprocessContent(data, entity);
    }

    public IScriptExecutor createExecutor(HttpServletRequest request) throws IOException {
        WebExecutor executor = new WebExecutor(this.getRepository(request), this.getWebRegistryPath(request), "/db/dirigible/registry/public" + this.getContentFolder());
        return executor;
    }
}

