/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.repository;

import java.util.HashMap;
import javax.naming.InitialContext;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.RepositoryException;
import org.eclipse.dirigible.repository.api.RepositoryFactory;
import org.eclipse.dirigible.repository.ext.db.WrappedDataSource;
import org.eclipse.dirigible.repository.ext.utils.RequestUtils;
import org.eclipse.dirigible.repository.logging.Logger;

public class RepositoryFacade {
    private static final Logger logger = Logger.getLogger(RepositoryFacade.class);
    private static final String LOCAL_DB_ACTION = "create";
    private static final String LOCAL_DB_NAME = "derby";
    private static final String REPOSITORY = "repository-instance";
    private static RepositoryFacade instance;
    private static DataSource localDataSource;
    private WrappedDataSource dataSource;
    public static final String INITIAL_CONTEXT = "InitialContext";
    private static final String DATASOURCE_DEFAULT = "DEFAULT_DATASOURCE";
    private static final String JNDI_DEFAULT_DATASOURCE = "jndiDefaultDataSource";

    private RepositoryFacade() {
    }

    public static RepositoryFacade getInstance() {
        if (instance == null) {
            instance = new RepositoryFacade();
        }
        return instance;
    }

    public IRepository getRepository(HttpServletRequest request) throws RepositoryException {
        IRepository repository = this.getRepositoryInstance(request);
        if (repository != null) {
            return repository;
        }
        try {
            DataSource dataSource = this.getDataSource(request);
            String user = RepositoryFacade.getUser(request);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("datasource", dataSource);
            parameters.put("user", user);
            parameters.put("recreate", Boolean.FALSE);
            repository = RepositoryFactory.createRepository(parameters);
            this.saveRepositoryInstance(request, repository);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException((Throwable)e);
        }
        return repository;
    }

    public DataSource getDataSource() {
        return this.getDataSource(null);
    }

    public DataSource getDataSource(HttpServletRequest request) {
        if (this.dataSource == null) {
            logger.debug("Lookup Datasource...");
            if (request == null) {
                logger.debug("No request - try from Env...");
                this.dataSource = this.getFromEnv();
            } else {
                logger.debug("Request exists - try from Request...");
                this.dataSource = this.getFromSession(request);
            }
            if (this.dataSource == null) {
                logger.debug("Try from Context...");
                this.dataSource = (WrappedDataSource)this.getFromContext();
            }
            if (this.dataSource == null) {
                this.dataSource = this.createLocal();
                logger.warn("Created Local DataSource!");
            } else {
                logger.debug("Lookup done.");
            }
        }
        return this.dataSource;
    }

    private WrappedDataSource getFromSession(HttpServletRequest request) {
        logger.debug("Try to get datasource from the Request");
        DataSource dataSource = null;
        dataSource = (DataSource)request.getSession().getAttribute(DATASOURCE_DEFAULT);
        if (dataSource != null) {
            WrappedDataSource wrappedDataSource = new WrappedDataSource(dataSource);
            logger.debug("Datasource retrieved from the Request");
            return wrappedDataSource;
        }
        logger.debug("Datasource NOT available in the Request");
        return null;
    }

    private WrappedDataSource getFromEnv() {
        logger.debug("Try to get datasource from System Properties");
        DataSource dataSource = null;
        dataSource = (DataSource)System.getProperties().get(DATASOURCE_DEFAULT);
        if (dataSource != null) {
            WrappedDataSource wrappedDataSource = new WrappedDataSource(dataSource);
            logger.debug("Datasource retrieved from System Properties");
            return wrappedDataSource;
        }
        logger.debug("Datasource NOT available in System Properties");
        return null;
    }

    private DataSource getFromContext() {
        String jndiName;
        InitialContext context;
        block4: {
            logger.debug("Try to get datasource from the InitialContext");
            context = (InitialContext)System.getProperties().get(INITIAL_CONTEXT);
            jndiName = System.getProperty(JNDI_DEFAULT_DATASOURCE);
            if (context != null && jndiName != null) break block4;
            return null;
        }
        try {
            DataSource datasource = (DataSource)context.lookup(jndiName);
            if (datasource != null) {
                WrappedDataSource wrappedDataSource = new WrappedDataSource(datasource);
                logger.debug("Datasource retrieved from InitialContext");
                return wrappedDataSource;
            }
            logger.error("Could not find DataSource in Initial Context by name: " + jndiName);
        }
        catch (Throwable e) {
            logger.error("Could not find DataSource", e);
        }
        return null;
    }

    private WrappedDataSource createLocal() {
        logger.debug("Try to create embedded datasource");
        localDataSource = (DataSource)System.getProperties().get(LOCAL_DB_NAME);
        if (localDataSource == null) {
            localDataSource = new EmbeddedDataSource();
            ((EmbeddedDataSource)localDataSource).setDatabaseName(LOCAL_DB_NAME);
            ((EmbeddedDataSource)localDataSource).setCreateDatabase(LOCAL_DB_ACTION);
            System.getProperties().put(LOCAL_DB_NAME, localDataSource);
        }
        logger.error("Embedded DataSource is used! In case you intentionally use local datasource, ignore this error.");
        WrappedDataSource wrappedDataSource = new WrappedDataSource(localDataSource);
        return wrappedDataSource;
    }

    public static String getUser(HttpServletRequest request) {
        return RequestUtils.getUser((HttpServletRequest)request);
    }

    private IRepository getRepositoryInstance(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        try {
            return (IRepository)request.getSession().getAttribute(REPOSITORY);
        }
        catch (IllegalStateException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void saveRepositoryInstance(HttpServletRequest request, IRepository repository) {
        if (request == null) {
            return;
        }
        try {
            request.getSession().setAttribute(REPOSITORY, (Object)repository);
        }
        catch (Exception exception) {
            repository.dispose();
        }
    }
}

