/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.jgit.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dirigible.ide.jgit.utils.GitProjectProperties;
import org.eclipse.dirigible.ide.jgit.utils.Messages;
import org.eclipse.dirigible.ide.repository.RepositoryFacade;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.ext.utils.FileUtils;

public class GitFileUtils {
    private static final String COULD_NOT_CREATE_TEMP_DIRECTORY = Messages.GitFileUtils_COULD_NOT_CREATE_TEMP_DIRECTORY;
    private static final String COULD_NOT_DELETE_TEMP_FILE = Messages.GitFileUtils_COULD_NOT_DELETE_TEMP_FILE;
    private static final String SLASH = "/";
    private static final String DOT_GIT = ".git";
    private static final int MINIMUM_URL_LENGTH = 25;

    public static boolean isValidRepositoryURI(String repositoryURI) {
        return repositoryURI.endsWith(DOT_GIT) && repositoryURI.length() > 25;
    }

    public static File createTempDirectory(String directory) throws IOException {
        return FileUtils.createTempDirectory((String)directory);
    }

    public static File createTempDirectory(String directory, String suffix) throws IOException {
        return FileUtils.createTempDirectory((String)directory, (String)suffix);
    }

    public static List<String> importProject(File gitDirectory, IRepository repository, String basePath, String dirigibleUser, GitProjectProperties properties) throws IOException {
        ArrayList<String> importedProjects = new ArrayList<String>(gitDirectory.listFiles().length);
        File[] fileArray = gitDirectory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String project = file.getName();
            if (file.isDirectory() && !project.equalsIgnoreCase(DOT_GIT)) {
                GitFileUtils.importProjectFromGitRepoToDGBWorkspace(file, repository, String.valueOf(basePath) + project);
                GitFileUtils.saveGitPropertiesFile(repository, properties, dirigibleUser, project);
                importedProjects.add(project);
            }
            ++n2;
        }
        return importedProjects;
    }

    private static void importProjectFromGitRepoToDGBWorkspace(File gitRepositoryFile, IRepository dirigibleRepository, String path) throws IOException {
        if (gitRepositoryFile.isDirectory()) {
            File[] fileArray = gitRepositoryFile.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                GitFileUtils.importProjectFromGitRepoToDGBWorkspace(file, dirigibleRepository, String.valueOf(path) + SLASH + file.getName());
                ++n2;
            }
        }
        if (!gitRepositoryFile.isDirectory()) {
            dirigibleRepository.createResource(path).setContent(GitFileUtils.readFile(gitRepositoryFile));
        }
    }

    public static byte[] readFile(File file) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FileInputStream in = new FileInputStream(file);
        try {
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            ((InputStream)in).close();
        }
        return out.toByteArray();
    }

    public static void deleteDGBRepositoryProject(IProject project, String dirigibleUser) throws IOException {
        String projectPath = project.getFullPath().toString();
        String repositoryPath = String.format("/db/dirigible/users/%s/workspace/", dirigibleUser);
        String fullPath = String.valueOf(repositoryPath) + projectPath;
        IRepository repository = RepositoryFacade.getInstance().getRepository();
        repository.getCollection(fullPath).delete();
    }

    public static void saveGitPropertiesFile(IRepository repository, GitProjectProperties properties, String user, String project) throws IOException {
        String dirigibleGitFolderPath = String.format("/db/dirigible/users/%s/git/%s", user, project);
        if (repository.hasCollection(dirigibleGitFolderPath)) {
            ICollection propertiesFolder = repository.getCollection(dirigibleGitFolderPath);
            if (propertiesFolder.getResource("git.property").exists()) {
                org.eclipse.dirigible.repository.api.IResource propertiesFile = propertiesFolder.getResource("git.property");
                propertiesFile.setContent(properties.getContent());
            } else {
                propertiesFolder.createResource("git.property", properties.getContent(), false, "text/plain");
            }
        } else {
            repository.createCollection(dirigibleGitFolderPath).createResource("git.property", properties.getContent(), false, "text/plain");
        }
    }

    public static void deleteProjectFolderFromDirectory(File parentDirectory, String selectedProject) {
        File[] fileArray = parentDirectory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File next = fileArray[n2];
            if (next.getName().equals(selectedProject)) {
                GitFileUtils.deleteFiles(next);
                next.delete();
            }
            ++n2;
        }
    }

    public static void deleteDirectory(File directory) {
        if (directory != null) {
            GitFileUtils.deleteFiles(directory);
            directory.delete();
        }
    }

    private static void deleteFiles(File directory) {
        if (directory != null) {
            File[] fileArray = directory.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    GitFileUtils.deleteDirectory(file);
                }
                if (!file.delete()) {
                    file.deleteOnExit();
                }
                ++n2;
            }
        }
    }

    public static void copyProjectToDirectory(IContainer source, File tempGitDirectory) throws IOException, CoreException {
        if (!source.exists()) {
            return;
        }
        IResource[] iResourceArray = source.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFolder) {
                GitFileUtils.copyProjectToDirectory((IContainer)((IFolder)resource), tempGitDirectory);
            }
            if (resource instanceof IFile) {
                IPath path = resource.getFullPath();
                StringBuilder resourceDirectory = new StringBuilder();
                int i = 0;
                while (i < path.segmentCount() - 1) {
                    resourceDirectory.append(SLASH + path.segment(i));
                    ++i;
                }
                resourceDirectory.append(SLASH);
                new File(tempGitDirectory, resourceDirectory.toString()).mkdirs();
                String resourcePath = resource.getFullPath().toOSString();
                InputStream in = ((IFile)resource).getContents();
                File outputFile = new File(tempGitDirectory, resourcePath);
                FileOutputStream out = new FileOutputStream(outputFile);
                IOUtils.copy((InputStream)in, (OutputStream)out);
                in.close();
                out.flush();
                out.close();
            }
            ++n2;
        }
    }

    public static GitProjectProperties getGitPropertiesForProject(IProject selectedProject, String user) throws IOException {
        IRepository dirigibleRepository = RepositoryFacade.getInstance().getRepository();
        String projectName = selectedProject.getName();
        org.eclipse.dirigible.repository.api.IResource resource = dirigibleRepository.getResource(String.format("/db/dirigible/users/%s/git/%s/git.property", user, projectName));
        ByteArrayInputStream in = new ByteArrayInputStream(resource.getContent());
        GitProjectProperties gitProperties = new GitProjectProperties(in);
        return gitProperties;
    }
}

