/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.templates.engine;

import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.diffmerge.impl.scopes.FilteredModelScope;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternApplication;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstance;
import org.eclipse.emf.diffmerge.patterns.core.util.LocationsUtil;
import org.eclipse.emf.diffmerge.patterns.templates.engine.TemplatePatternsEnginePlugin;
import org.eclipse.emf.diffmerge.patterns.templates.engine.ext.ISemanticRuleProvider;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePattern;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternData;
import org.eclipse.emf.diffmerge.util.ModelsUtil;
import org.eclipse.emf.ecore.EObject;

public final class TemplatePatternsUtil {
    private TemplatePatternsUtil() {
    }

    public static void adjust(FilteredModelScope scope_p) {
        TemplatePatternsUtil.adjust(scope_p, true);
        TemplatePatternsUtil.adjust(scope_p, false);
    }

    public static void adjust(FilteredModelScope scope_p, boolean extend_p) {
        ISemanticRuleProvider ruleProvider;
        List roots = scope_p.getContents();
        if (!roots.isEmpty() && (ruleProvider = TemplatePatternsEnginePlugin.getDefault().getSemanticRuleProviderFor(roots.get(0))) != null) {
            ruleProvider.adjustScope(scope_p, extend_p);
        }
    }

    public static List<EObject> getApplicationRoots(IPatternApplication application_p) {
        List result;
        if (application_p instanceof IPatternInstance && ((IPatternInstance)application_p).getPatternData() instanceof TemplatePatternData) {
            TemplatePatternData data = (TemplatePatternData)((IPatternInstance)application_p).getPatternData();
            result = data.getInstanceElements();
        } else {
            result = LocationsUtil.getRoleElements((IPatternApplication)application_p);
        }
        result = ModelsUtil.getRoots((Collection)result);
        return Collections.unmodifiableList(result);
    }

    public static TemplatePatternData getPatternData(IPatternApplication application_p) {
        IPatternInstance instance;
        TemplatePatternData result = null;
        if (application_p instanceof IPatternInstance && (instance = (IPatternInstance)application_p).getPatternData() instanceof TemplatePatternData) {
            result = (TemplatePatternData)instance.getPatternData();
        }
        return result;
    }

    public static void updateLastModificationStamp(TemplatePattern pattern_p) {
        pattern_p.setLastModificationStamp(Calendar.getInstance().getTime().toString());
    }
}

