/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.wizards.export;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.corrosion.Messages;
import org.eclipse.corrosion.RustManager;
import org.eclipse.corrosion.cargo.core.CargoProjectTester;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CargoExportWizardPage
extends WizardPage {
    private IProject project;
    private Label outputLocationLabel;
    private ControlDecoration projectControlDecoration;
    private Combo toolchainCombo;
    private Button allowDirtyCheckbox;
    private Button noVerifyCheckbox;
    private Button noMetadataCheckbox;
    private IPreferenceStore store = CorrosionPlugin.getDefault().getPreferenceStore();
    private static CargoProjectTester tester = new CargoProjectTester();

    public IProject getProject() {
        return this.project;
    }

    public String getToolchain() {
        int toolchainIndex = this.toolchainCombo.getSelectionIndex();
        if (toolchainIndex != 0) {
            return this.toolchainCombo.getItem(toolchainIndex);
        }
        return "";
    }

    public Boolean noVerify() {
        return this.noVerifyCheckbox.getSelection();
    }

    public Boolean noMetadata() {
        return this.noMetadataCheckbox.getSelection();
    }

    public Boolean allowDirty() {
        return this.allowDirtyCheckbox.getSelection();
    }

    protected CargoExportWizardPage(IProject project) {
        super(CargoExportWizardPage.class.getName());
        this.setTitle(Messages.CargoExportWizardPage_title);
        this.setDescription(Messages.CargoExportWizardPage_description);
        this.setImageDescriptor(CorrosionPlugin.getDefault().getImageRegistry().getDescriptor("images/cargo.png"));
        if (project != null) {
            this.project = project;
        }
    }

    public void createControl(Composite parent) {
        Image errorImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        Composite container = new Composite(parent, 2048);
        this.setControl((Control)container);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo(container);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        Label projectLabelLabel = new Label(container, 0);
        projectLabelLabel.setText(Messages.CargoExportWizardPage_project);
        projectLabelLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        Text projectText = new Text(container, 2048);
        projectText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.project != null) {
            projectText.setText(this.project.getName());
        }
        projectText.addModifyListener(e -> {
            this.project = !projectText.getText().isEmpty() ? ResourcesPlugin.getWorkspace().getRoot().getProject(projectText.getText()) : null;
            this.setPageComplete(this.isPageComplete());
        });
        this.projectControlDecoration = new ControlDecoration((Control)projectText, 16512);
        this.projectControlDecoration.setImage(errorImage);
        Button browseButton = new Button(container, 0);
        browseButton.setText(Messages.CargoExportWizardPage_browse);
        browseButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        browseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            ListSelectionDialog dialog = new ListSelectionDialog(browseButton.getShell(), (Object)ResourcesPlugin.getWorkspace().getRoot(), (IStructuredContentProvider)new BaseWorkbenchContentProvider(), (ILabelProvider)new WorkbenchLabelProvider(), Messages.CargoExportWizardPage_selectProject);
            dialog.setTitle(Messages.CargoExportWizardPage_projectSelection);
            int returnCode = dialog.open();
            Object[] results = dialog.getResult();
            if (returnCode == 0 && results.length > 0) {
                this.project = (IProject)results[0];
                projectText.setText(this.project.getName());
            }
        }));
        new Label(container, 0);
        this.outputLocationLabel = new Label(container, 0);
        this.outputLocationLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label toolchainLabel = new Label(container, 0);
        toolchainLabel.setText(Messages.CargoExportWizardPage_toolchain);
        toolchainLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.toolchainCombo = new Combo(container, 12);
        this.toolchainCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        String defaultString = "Default";
        String defaultToolchain = RustManager.getDefaultToolchain();
        if (!defaultToolchain.isEmpty()) {
            defaultString = String.valueOf(defaultString) + NLS.bind((String)Messages.CargoExportWizardPage_currentToolchain, (Object)defaultToolchain);
        }
        this.toolchainCombo.add(defaultString);
        this.toolchainCombo.select(0);
        for (String toolchain : RustManager.getToolchains()) {
            this.toolchainCombo.add(toolchain);
        }
        new Label(container, 0);
        this.noVerifyCheckbox = new Button(container, 32);
        this.noVerifyCheckbox.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.noVerifyCheckbox.setText(Messages.CargoExportWizardPage_dontVerifyContent);
        this.noMetadataCheckbox = new Button(container, 32);
        this.noMetadataCheckbox.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.noMetadataCheckbox.setText(Messages.CargoExportWizardPage_ignoreWarningMatadata);
        this.allowDirtyCheckbox = new Button(container, 32);
        this.allowDirtyCheckbox.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.allowDirtyCheckbox.setText(Messages.CargoExportWizardPage_allowDirtyDirectories);
        this.setPageComplete(this.isPageComplete());
    }

    public boolean isPageComplete() {
        File cargo = new File(this.store.getString("corrosion.rustup_cargoPath"));
        if (!(cargo.exists() && cargo.isFile() && cargo.canExecute())) {
            this.setErrorMessage(Messages.CargoExportWizardPage_cargoCommandNotFound);
            return false;
        }
        if (this.project == null || !this.project.exists() || !tester.test(this.project, "isCargoProject", null, null)) {
            this.setErrorMessage(Messages.CargoExportWizardPage_invalidCargoProject);
            this.outputLocationLabel.setText("");
            this.projectControlDecoration.show();
            return false;
        }
        this.outputLocationLabel.setText(NLS.bind((String)Messages.CargoExportWizardPage_outputLocation, (Object)this.project.getName()));
        this.projectControlDecoration.hide();
        this.setErrorMessage(null);
        return true;
    }
}

