/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.ui.refactoring.IDependentElementsCalculator;

public class DefaultDependentElementsCalculator
implements IDependentElementsCalculator {
    @Inject
    private IQualifiedNameProvider nameProvider;
    private static final int MONITOR_CHUNK_SIZE = 1000;

    public List<URI> getDependentElementURIs(EObject baseElement, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        ArrayList elementURIs = Lists.newArrayList();
        int counter = 0;
        TreeIterator iterator = EcoreUtil.getAllProperContents((EObject)baseElement, (boolean)false);
        while (iterator.hasNext()) {
            URI childURI;
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            EObject childElement = (EObject)iterator.next();
            if (this.nameProvider.getFullyQualifiedName(childElement) != null && (childURI = EcoreUtil.getURI((EObject)childElement)) != null) {
                elementURIs.add(childURI);
            }
            if (++counter % 1000 != 0) continue;
            progress.worked(1);
            progress.setWorkRemaining(2);
        }
        return elementURIs;
    }
}

