/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.core.resources;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.emf.mwe.core.resources.ResourceLoader;
import org.eclipse.emf.mwe.core.resources.ResourceLoaderDefaultImpl;

public class ResourceLoaderFactory {
    public static final String PARAM_RESOURCELOADER_CLASS = "org.eclipse.emf.mwe.core.resources.ResourceLoader";
    private static Class<?> resourceLoaderImpl;
    private static final ThreadLocal<ResourceLoader> current;

    static {
        current = new ThreadLocal();
    }

    public static void setCurrentThreadResourceLoader(ResourceLoader rl) {
        current.set(rl);
    }

    public static ResourceLoader getCurrentThreadResourceLoader() {
        return current.get();
    }

    private static void initResourceLoaderClass() {
        String name = System.getProperty(PARAM_RESOURCELOADER_CLASS, ResourceLoaderDefaultImpl.class.getName());
        if (resourceLoaderImpl == null || name != null && !name.equals(resourceLoaderImpl.getName())) {
            try {
                resourceLoaderImpl = Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static ResourceLoader createResourceLoader() throws RuntimeException {
        if (current.get() != null) {
            return current.get();
        }
        ResourceLoaderFactory.initResourceLoaderClass();
        try {
            return (ResourceLoader)resourceLoaderImpl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

