/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component.tabs;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class E4ToolItemMenu {
    public static final String SEPARATOR = "~separator~";
    private final IEclipseContext context;
    private final ArrayList<String> commandIds = new ArrayList();
    private final Menu menu;
    private final ECommandService commandService;
    private final EHandlerService handlerService;
    private final ToolItem toolItem;

    public E4ToolItemMenu(final ToolBar parent, IEclipseContext context) {
        this.toolItem = new ToolItem(parent, 4);
        this.context = context;
        this.commandService = (ECommandService)this.context.get(ECommandService.class);
        this.handlerService = (EHandlerService)this.context.get(EHandlerService.class);
        this.menu = new Menu((Decorations)parent.getShell(), 8);
        this.toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Rectangle rect = E4ToolItemMenu.this.toolItem.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = parent.toDisplay(pt);
                E4ToolItemMenu.this.menu.setLocation(pt.x, pt.y);
                E4ToolItemMenu.this.menu.setVisible(true);
                MenuItem[] menuItemArray = E4ToolItemMenu.this.menu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem mi = menuItemArray[n2];
                    if (mi.getData() instanceof ParameterizedCommand) {
                        ParameterizedCommand cmd = (ParameterizedCommand)mi.getData();
                        mi.setEnabled(E4ToolItemMenu.this.handlerService.canExecute(cmd));
                    }
                    ++n2;
                }
            }
        });
    }

    public void addCommands(Collection<String> commandIds) {
        this.commandIds.addAll(commandIds);
        for (String id : commandIds) {
            if (id.equals(SEPARATOR)) {
                new MenuItem(this.menu, 2);
                continue;
            }
            ParameterizedCommand myCommand = this.commandService.createCommand(id, null);
            if (myCommand == null) continue;
            final MenuItem item = new MenuItem(this.menu, 8);
            try {
                item.setText(myCommand.getName());
            }
            catch (NotDefinedException e1) {
                item.setText(id);
                e1.printStackTrace();
            }
            item.setData((Object)myCommand);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ParameterizedCommand cmd = (ParameterizedCommand)item.getData();
                    E4ToolItemMenu.this.handlerService.executeHandler(cmd);
                }
            });
        }
    }

    public ToolItem getToolItem() {
        return this.toolItem;
    }
}

