/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.details;

import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSHelpObject;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSIntro;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.CSAbstractDetails;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.ICSMaster;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.details.SimpleCSHelpDetails;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.details.SimpleDetailsMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.parts.PDESourceViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Section;

public class SimpleCSIntroDetails
extends CSAbstractDetails {
    private ISimpleCSIntro fIntro = null;
    private PDESourceViewer fContentViewer = null;
    private Section fMainSection = null;
    private SimpleCSHelpDetails fHelpSection;
    private boolean fBlockEvents;

    public SimpleCSIntroDetails(ICSMaster elementSection) {
        super(elementSection, "simplecs-context");
        this.fHelpSection = new SimpleCSHelpDetails(elementSection);
        this.fBlockEvents = false;
    }

    public void setData(ISimpleCSIntro object) {
        this.fIntro = object;
        this.fHelpSection.setData((ISimpleCSHelpObject)object);
    }

    @Override
    public void selectionChanged(IFormPart part, ISelection selection) {
        Object object = this.getFirstSelectedObject(selection);
        if (object == null || !(object instanceof ISimpleCSIntro)) {
            return;
        }
        this.setData((ISimpleCSIntro)object);
        this.updateFields();
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        this.fHelpSection.initialize(form);
    }

    @Override
    public void createDetails(Composite parent) {
        GridData data = null;
        this.fMainSection = this.getToolkit().createSection(parent, 384);
        this.fMainSection.clientVerticalSpacing = 6;
        this.fMainSection.setText(SimpleDetailsMessages.SimpleCSIntroDetails_mainSectionText);
        this.fMainSection.setDescription(SimpleDetailsMessages.SimpleCSIntroDetails_mainSectionDesc);
        this.fMainSection.setLayout((Layout)FormLayoutFactory.createClearGridLayout((boolean)false, (int)1));
        data = new GridData(768);
        this.fMainSection.setLayoutData((Object)data);
        this.getPage().alignSectionHeaders(this.getMasterSection().getSection(), this.fMainSection);
        Composite mainSectionClient = this.getToolkit().createComposite((Composite)this.fMainSection);
        mainSectionClient.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout((boolean)false, (int)2));
        this.createUIFieldContent(mainSectionClient);
        this.getToolkit().paintBordersFor(mainSectionClient);
        this.fMainSection.setClient((Control)mainSectionClient);
        this.markDetailsPart((Control)this.fMainSection);
        this.fHelpSection.createDetails(parent);
    }

    private void createUIFieldContent(Composite parent) {
        GridData data = null;
        Color foreground = this.getToolkit().getColors().getColor("org.eclipse.ui.forms.TITLE");
        Label label = this.getToolkit().createLabel(parent, SimpleDetailsMessages.SimpleCSIntroDetails_attrBody, 64);
        label.setForeground(foreground);
        int style = 130;
        data = new GridData(style);
        label.setLayoutData((Object)data);
        this.fContentViewer = new PDESourceViewer(this.getPage());
        this.fContentViewer.createUI(parent, 90, 60);
        ((GridData)this.fContentViewer.getViewer().getTextWidget().getLayoutData()).horizontalIndent = 3;
    }

    public boolean doGlobalAction(String actionId) {
        return this.fContentViewer.doGlobalAction(actionId);
    }

    @Override
    public void hookListeners() {
        this.createUIListenersContentViewer();
        this.fHelpSection.hookListeners();
    }

    private void createUIListenersContentViewer() {
        this.fContentViewer.createUIListeners();
        this.fContentViewer.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                if (SimpleCSIntroDetails.this.fBlockEvents) {
                    return;
                }
                if (SimpleCSIntroDetails.this.fIntro == null) {
                    return;
                }
                IDocument document = event.getDocument();
                if (document == null) {
                    return;
                }
                String text = document.get().trim();
                if (SimpleCSIntroDetails.this.fIntro.getDescription() != null) {
                    SimpleCSIntroDetails.this.fIntro.getDescription().setContent(text);
                }
            }
        });
    }

    @Override
    public void updateFields() {
        if (this.fIntro == null) {
            return;
        }
        this.fHelpSection.updateFields();
        if (this.fIntro.getDescription() == null) {
            return;
        }
        this.fBlockEvents = true;
        this.fContentViewer.getDocument().set(this.fIntro.getDescription().getContent());
        this.fBlockEvents = false;
        boolean editable = this.isEditableElement();
        this.fContentViewer.getViewer().setEditable(editable);
    }

    public void dispose() {
        if (this.fContentViewer != null) {
            this.fContentViewer.unsetMenu();
            this.fContentViewer = null;
        }
        super.dispose();
    }

    public boolean canPaste(Clipboard clipboard) {
        return this.fContentViewer.canPaste();
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
    }
}

