/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.comma.monitoring.lib.CDispatcher;
import org.eclipse.comma.monitoring.lib.CMonitorResults;
import org.eclipse.comma.monitoring.lib.messages.CObservedCommand;
import org.eclipse.comma.monitoring.lib.messages.CObservedMessage;
import org.eclipse.comma.monitoring.lib.messages.CObservedNotification;
import org.eclipse.comma.monitoring.lib.messages.CObservedReply;

public class CReorderDispatcher
extends CDispatcher {
    private CDispatcher next;
    private Map<String, List<CObservedNotification>> queues = new HashMap<String, List<CObservedNotification>>();

    public CReorderDispatcher(CDispatcher dispatcher) {
        this.next = dispatcher;
    }

    @Override
    public void consume(CObservedMessage message) throws Exception {
        if (message instanceof CObservedCommand) {
            String key = this.makeKey(message, true);
            this.queues.put(key, new ArrayList());
            this.next.consume(message);
            return;
        }
        if (message instanceof CObservedNotification) {
            String key = this.makeKey(message, false);
            if (this.queues.containsKey(key)) {
                this.queues.get(key).add((CObservedNotification)message);
            } else {
                this.next.consume(message);
            }
            return;
        }
        if (message instanceof CObservedReply) {
            String key = this.makeKey(message, false);
            double timestamp = message.getTimeDelta();
            this.next.consume(message);
            for (CObservedNotification n : this.queues.get(key)) {
                n.setTimeDelta(timestamp);
                this.next.consume(n);
            }
            this.queues.remove(key);
            return;
        }
        this.next.consume(message);
    }

    @Override
    public void traceEnded() throws Exception {
        this.next.traceEnded();
    }

    @Override
    public List<CMonitorResults> getResults() {
        return this.next.getResults();
    }

    private String makeKey(CObservedMessage message, boolean isCall) {
        if (isCall) {
            return String.valueOf(message.getSource()) + "_" + message.getSourcePort() + "_" + message.getDestination() + "_" + message.getDestinationPort();
        }
        return String.valueOf(message.getDestination()) + "_" + message.getDestinationPort() + "_" + message.getSource() + "_" + message.getSourcePort();
    }

    @Override
    public List<CMonitorResults> getIssuesForLastEvent() {
        return this.next.getIssuesForLastEvent();
    }
}

