/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableLongBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoubleLongPredicate;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleLongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.map.primitive.DoubleLongMap;
import org.eclipse.collections.api.map.primitive.ImmutableDoubleLongMap;
import org.eclipse.collections.api.map.primitive.ImmutableLongDoubleMap;
import org.eclipse.collections.api.map.primitive.MutableDoubleLongMap;
import org.eclipse.collections.api.map.primitive.MutableLongDoubleMap;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.tuple.primitive.DoubleLongPair;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedDoubleLongProcedure;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableLongCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.LongBags;
import org.eclipse.collections.impl.factory.primitive.LongDoubleMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableLongIterator;
import org.eclipse.collections.impl.map.mutable.primitive.DoubleLongHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableDoubleSet;

final class ImmutableDoubleLongHashMap
implements ImmutableDoubleLongMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableDoubleLongMap delegate;

    ImmutableDoubleLongHashMap(DoubleLongMap delegate) {
        this.delegate = new DoubleLongHashMap(delegate);
    }

    public long get(double key) {
        return this.delegate.get(key);
    }

    public long getIfAbsent(double key, long ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public long getOrThrow(double key) {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(double key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(long value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(LongProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(DoubleProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(DoubleLongProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    public boolean allSatisfyKeyValue(DoubleLongPredicate predicate) {
        return this.delegate.allSatisfyKeyValue(predicate);
    }

    public LazyDoubleIterable keysView() {
        return this.delegate.keysView();
    }

    public RichIterable<DoubleLongPair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    public ImmutableLongDoubleMap flipUniqueValues() {
        MutableLongDoubleMap result = LongDoubleMaps.mutable.empty();
        this.forEachKeyValue((DoubleLongProcedure & Serializable)(key, value) -> {
            if (result.containsKey(value)) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + result.get(value) + " and key: " + key);
            }
            result.put(value, key);
        });
        return result.toImmutable();
    }

    public ImmutableDoubleLongMap select(DoubleLongPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableDoubleLongMap reject(DoubleLongPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        return (T)this.delegate.injectInto(injectedValue, function);
    }

    public RichIterable<LongIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            MutableLongIterator iterator = this.delegate.longIterator();
            while (iterator.hasNext()) {
                MutableLongBag batch = LongBags.mutable.empty();
                for (int i = 0; i < size && iterator.hasNext(); ++i) {
                    batch.add(iterator.next());
                }
                result.add((Object)batch.toImmutable());
            }
        }
        return result.toImmutable();
    }

    public ImmutableDoubleLongMap toImmutable() {
        return this;
    }

    public LongIterator longIterator() {
        return new UnmodifiableLongIterator((LongIterator)this.delegate.longIterator());
    }

    public void each(LongProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public int count(LongPredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(LongPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(LongPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(LongPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableLongBag select(LongPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableLongBag reject(LongPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <V> ImmutableBag<V> collect(LongToObjectFunction<? extends V> function) {
        MutableBag bag = this.delegate.collect(function);
        return bag.toImmutable();
    }

    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public long sum() {
        return this.delegate.sum();
    }

    public long max() {
        return this.delegate.max();
    }

    public long maxIfEmpty(long defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public long min() {
        return this.delegate.min();
    }

    public long minIfEmpty(long defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public long[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableLongList toSortedList() {
        return this.delegate.toSortedList();
    }

    public long[] toArray() {
        return this.delegate.toArray();
    }

    public long[] toArray(long[] target) {
        return this.delegate.toArray(target);
    }

    public boolean contains(long value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(long ... source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(LongIterable source) {
        return this.delegate.containsAll(source);
    }

    public MutableLongList toList() {
        return this.delegate.toList();
    }

    public MutableLongSet toSet() {
        return this.delegate.toSet();
    }

    public MutableLongBag toBag() {
        return this.delegate.toBag();
    }

    public LazyLongIterable asLazy() {
        return this.delegate.asLazy();
    }

    public ImmutableDoubleLongMap newWithKeyValue(double key, long value) {
        DoubleLongHashMap map = new DoubleLongHashMap(this.size() + 1);
        map.putAll((DoubleLongMap)this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableDoubleLongMap newWithoutKey(double key) {
        DoubleLongHashMap map = new DoubleLongHashMap(this.size());
        map.putAll((DoubleLongMap)this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableDoubleLongMap newWithoutAllKeys(DoubleIterable keys) {
        DoubleLongHashMap map = new DoubleLongHashMap(this.size());
        map.putAll((DoubleLongMap)this);
        DoubleIterator iterator = keys.doubleIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableDoubleSet keySet() {
        return UnmodifiableDoubleSet.of(this.delegate.keySet());
    }

    public MutableLongCollection values() {
        return UnmodifiableLongCollection.of(this.delegate.values());
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableDoubleLongMapSerializationProxy((DoubleLongMap)this);
    }

    protected static class ImmutableDoubleLongMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private DoubleLongMap map;

        public ImmutableDoubleLongMapSerializationProxy() {
        }

        protected ImmutableDoubleLongMapSerializationProxy(DoubleLongMap map) {
            this.map = map;
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue((DoubleLongProcedure)new CheckedDoubleLongProcedure(){

                    @Override
                    public void safeValue(double key, long value) throws IOException {
                        out.writeDouble(key);
                        out.writeLong(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            DoubleLongHashMap deserializedMap = new DoubleLongHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readDouble(), in.readLong());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

