/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.standalone.ui.internal.application;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.standalone.ui.internal.Messages;
import org.eclipse.cft.server.standalone.ui.internal.startcommand.JavaTypeResolver;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;

public class JavaPackageFragmentRootHandler {
    private IJavaProject javaProject;
    private IType type;
    private CloudFoundryServer cloudServer;

    public JavaPackageFragmentRootHandler(IJavaProject javaProject, CloudFoundryServer cloudServer) {
        this.javaProject = javaProject;
        this.cloudServer = cloudServer;
    }

    public IPackageFragmentRoot[] getPackageFragmentRoots(IProgressMonitor monitor) throws CoreException {
        IType type = this.getMainType(monitor);
        IPath[] classpathEntries = null;
        ILaunchConfiguration configuration = null;
        try {
            configuration = this.createConfiguration(type);
            classpathEntries = this.getRuntimeClasspaths(configuration);
        }
        finally {
            if (configuration != null) {
                configuration.delete();
            }
        }
        ArrayList pckRoots = new ArrayList();
        List<IJavaProject> javaProjectsToSearch = this.getOrderedJavaProjects(this.javaProject);
        IPath[] iPathArray = classpathEntries;
        int n = classpathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            for (IJavaProject javaProject : javaProjectsToSearch) {
                try {
                    IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
                    if (roots == null) continue;
                    ArrayList<IPackageFragmentRoot> foundRoots = new ArrayList<IPackageFragmentRoot>();
                    IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
                    int n3 = roots.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n4];
                        if (JavaPackageFragmentRootHandler.isRootAtEntry(packageFragmentRoot, path)) {
                            foundRoots.add(packageFragmentRoot);
                        }
                        ++n4;
                    }
                    if (foundRoots.isEmpty()) continue;
                    pckRoots.addAll(foundRoots);
                    break;
                }
                catch (Exception e) {
                    throw CloudErrorUtil.toCoreException((Throwable)e);
                }
            }
            ++n2;
        }
        return pckRoots.toArray(new IPackageFragmentRoot[pckRoots.size()]);
    }

    public IType getMainType(IProgressMonitor monitor) throws CoreException {
        if (this.type == null) {
            this.type = new JavaTypeResolver(this.javaProject, this.cloudServer.getServer().getServerType().getId()).getMainTypesFromSource(monitor);
            if (this.type == null) {
                throw CloudErrorUtil.toCoreException((String)Messages.JavaCloudFoundryArchiver_ERROR_NO_MAIN);
            }
        }
        return this.type;
    }

    protected List<IJavaProject> getOrderedJavaProjects(IJavaProject project) {
        ArrayList<String> collectedProjects = new ArrayList<String>();
        this.getOrderedJavaProjectNames(Arrays.asList(project.getProject().getName()), collectedProjects);
        ArrayList<IJavaProject> projects = new ArrayList<IJavaProject>();
        for (String name : collectedProjects) {
            IJavaProject jvPrj;
            IProject prj = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            if (prj == null || (jvPrj = JavaCore.create((IProject)prj)) == null || !jvPrj.exists()) continue;
            projects.add(jvPrj);
        }
        return projects;
    }

    protected void getOrderedJavaProjectNames(List<String> sameLevelRequiredProjects, List<String> collectedProjects) {
        if (sameLevelRequiredProjects == null) {
            return;
        }
        ArrayList<String> nextLevelRequiredProjects = new ArrayList<String>();
        for (String name : sameLevelRequiredProjects) {
            try {
                String[] names;
                IJavaProject jvPrj;
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                if (project == null || (jvPrj = JavaCore.create((IProject)project)) == null || !jvPrj.exists()) continue;
                if (!collectedProjects.contains(name)) {
                    collectedProjects.add(name);
                }
                if ((names = jvPrj.getRequiredProjectNames()) == null || names.length <= 0) continue;
                String[] stringArray = names;
                int n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    String reqName = stringArray[n2];
                    if (!nextLevelRequiredProjects.contains(reqName)) {
                        nextLevelRequiredProjects.add(reqName);
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                CloudFoundryPlugin.logError((Throwable)e);
            }
        }
        if (!nextLevelRequiredProjects.isEmpty()) {
            this.getOrderedJavaProjectNames(nextLevelRequiredProjects, collectedProjects);
        }
    }

    protected ILaunchConfiguration createConfiguration(IType type) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        ILaunchConfigurationWorkingCopy workingCopy = configType.newInstance(null, manager.generateLaunchConfigurationName(type.getTypeQualifiedName('.')));
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, type.getFullyQualifiedName());
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, type.getJavaProject().getElementName());
        workingCopy.setMappedResources(new IResource[]{type.getUnderlyingResource()});
        return workingCopy.doSave();
    }

    protected IPath[] getRuntimeClasspaths(ILaunchConfiguration configuration) throws CoreException {
        IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)configuration);
        entries = JavaRuntime.resolveRuntimeClasspath((IRuntimeClasspathEntry[])entries, (ILaunchConfiguration)configuration);
        ArrayList<IPath> userEntries = new ArrayList<IPath>(entries.length);
        int i = 0;
        while (i < entries.length) {
            IPath entry;
            String location;
            if (entries[i].getClasspathProperty() == 3 && (location = entries[i].getLocation()) != null && !userEntries.contains(entry = Path.fromOSString((String)location))) {
                userEntries.add(entry);
            }
            ++i;
        }
        return userEntries.toArray(new IPath[userEntries.size()]);
    }

    private static boolean isRootAtEntry(IPackageFragmentRoot root, IPath entry) {
        IResource resource;
        try {
            IClasspathEntry cpe = root.getRawClasspathEntry();
            if (cpe.getEntryKind() == 3) {
                IPath location;
                IPath outputLocation = cpe.getOutputLocation();
                if (outputLocation == null) {
                    outputLocation = root.getJavaProject().getOutputLocation();
                }
                if (entry.equals((Object)(location = ResourcesPlugin.getWorkspace().getRoot().findMember(outputLocation).getLocation()))) {
                    return true;
                }
            }
        }
        catch (JavaModelException e) {
            CloudFoundryPlugin.logError((Throwable)e);
        }
        if ((resource = root.getResource()) != null && entry.equals((Object)resource.getLocation())) {
            return true;
        }
        IPath path = root.getPath();
        return path != null && entry.equals((Object)path);
    }
}

