/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.standalone.ui.internal;

import java.util.List;
import org.eclipse.cft.server.standalone.ui.internal.Messages;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class SelectMainTypeWizardPage
extends WizardPage {
    private Combo typeCombo;
    boolean canFinish = false;
    private final List<IType> mainTypes;
    private IType selectedMainType;

    protected SelectMainTypeWizardPage(List<IType> mainTypes, ImageDescriptor descriptor) {
        super(Messages.SelectMainTypeWizardPage_TITLE);
        this.mainTypes = mainTypes;
        this.setTitle(Messages.SelectMainTypeWizardPage_TITLE);
        this.setDescription(Messages.SelectMainTypeWizardPage_WIZARD_DESCRIPTION);
        if (descriptor != null) {
            this.setImageDescriptor(descriptor);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(10, 10).applyTo(composite);
        Label mainTypeLabel = new Label(composite, 0);
        mainTypeLabel.setText(Messages.SelectMainTypeWizardPage_LABEL);
        GridDataFactory.fillDefaults().applyTo((Control)mainTypeLabel);
        this.typeCombo = new Combo(composite, 2056);
        GridDataFactory.fillDefaults().applyTo((Control)this.typeCombo);
        this.typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectMainTypeWizardPage.this.resolveSelection();
            }
        });
        String[] comboItems = new String[this.mainTypes.size()];
        int i = 0;
        while (i < comboItems.length && i < this.mainTypes.size()) {
            String name;
            comboItems[i] = name = this.mainTypes.get(i).getFullyQualifiedName();
            ++i;
        }
        this.typeCombo.setItems(comboItems);
        if (this.mainTypes.size() > 0) {
            this.typeCombo.select(0);
        }
        this.resolveSelection();
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
    }

    private void resolveSelection() {
        if (this.typeCombo != null && !this.typeCombo.isDisposed()) {
            int index = this.typeCombo.getSelectionIndex();
            if (index >= 0) {
                String typeName = this.typeCombo.getItem(index);
                for (IType type : this.mainTypes) {
                    if (!type.getFullyQualifiedName().equals(typeName)) continue;
                    this.selectedMainType = type;
                    break;
                }
            }
            this.update();
        }
    }

    private void update() {
        this.setErrorMessage(null);
        boolean bl = this.canFinish = this.getSelectedMainType() != null;
        if (this.getWizard() != null && this.getWizard().getContainer() != null) {
            this.getWizard().getContainer().updateButtons();
            this.setPageComplete(this.canFinish);
        }
    }

    public boolean isPageComplete() {
        return this.canFinish;
    }

    public IType getSelectedMainType() {
        return this.selectedMainType;
    }
}

