/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import org.eclipse.cft.server.core.internal.ApplicationUrlLookupService;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.ui.internal.ICoreRunnable;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.wizards.PartsWizardPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractURLWizardPage
extends PartsWizardPage {
    protected boolean refreshedDomains = false;
    private ApplicationUrlLookupService urlLookup;

    protected AbstractURLWizardPage(String pageName, String title, ImageDescriptor titleImage, ApplicationUrlLookupService urlLookup) {
        super(pageName, title, titleImage);
        this.urlLookup = urlLookup;
    }

    protected AbstractURLWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        this(pageName, title, titleImage, null);
    }

    protected ApplicationUrlLookupService getApplicationUrlLookup() {
        return this.urlLookup;
    }

    protected void refreshApplicationUrlDomains() {
        final ApplicationUrlLookupService urlLookup = this.getApplicationUrlLookup();
        if (urlLookup == null) {
            this.update(true, CloudFoundryPlugin.getStatus((String)Messages.AbstractURLWizardPage_ERROR_NO_URL_HANDLER, (int)4));
            return;
        }
        final String operationLabel = Messages.AbstractURLWizardPage_LABEL_FETCHING_DOMAIN;
        ICoreRunnable runnable = new ICoreRunnable(){

            @Override
            public void run(IProgressMonitor coreRunnerMonitor) throws CoreException {
                SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)coreRunnerMonitor, (String)operationLabel, (int)100);
                try {
                    urlLookup.refreshDomains((IProgressMonitor)subProgress);
                    AbstractURLWizardPage.this.refreshedDomains = true;
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            AbstractURLWizardPage.this.setMessage(null);
                            AbstractURLWizardPage.this.domainsRefreshed();
                        }
                    });
                }
                finally {
                    subProgress.done();
                }
            }
        };
        this.runAsynchWithWizardProgress(runnable, operationLabel);
    }

    protected abstract void domainsRefreshed();
}

