/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.tests.multiphases;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.diffmerge.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.transition.system2subsystem.tests.System2SubsystemTestActivator;
import org.polarsys.capella.transition.system2subsystem.tests.multiphases.MultiPhasesTest;
import org.polarsys.capella.transition.system2subsystem.tests.util.DiffHelper;
import org.polarsys.capella.transition.system2subsystem.tests.util.ProjectCreationHelper;
import org.polarsys.capella.transition.system2subsystem.tests.util.QualifiedMatchPolicy;

public class MultiphasesTransitionTest
extends MultiPhasesTest {
    private static final String OUTPUT_PROJECT_NAME = "PC1PC2";
    private static final String OUTPUT_FILENAME = "PC1PC2.melodymodeller";
    private static final String PC1 = "eeed51b0-e875-4f01-b43c-7bda9d0a2699";
    private static final String PC2 = "0adec35f-010e-4281-8a61-7146263486e7";

    public MultiphasesTransitionTest() {
    }

    public MultiphasesTransitionTest(boolean withLibrary) {
        super(withLibrary);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        ProjectCreationHelper helper = new ProjectCreationHelper(true, true);
        IProject project = helper.createNewEclipseProject(OUTPUT_PROJECT_NAME, null, Collections.emptyList(), (IProgressMonitor)new NullProgressMonitor());
        helper.createSemanticResource(project, (IProgressMonitor)new NullProgressMonitor());
    }

    public void tearDown() {
        try {
            ResourcesPlugin.getWorkspace().getRoot().getProject(OUTPUT_PROJECT_NAME).delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            System2SubsystemTestActivator.getDefault().getLog().log((IStatus)new Status(e.getStatus().getSeverity(), "org.polarsys.capella.transition.system2subsystem.tests.ju", e.getMessage(), (Throwable)e));
        }
    }

    @Override
    public List<String> getRequiredTestModels() {
        return Arrays.asList("init_transition", "PC1PC2_result");
    }

    @Override
    protected Collection<?> getProjectionElements() {
        return this.getObjects(new String[]{PC1, PC2});
    }

    @Override
    protected String getOutputModelPlatformURIString() {
        return NLS.bind((String)"/{0}/{1}", (Object)OUTPUT_PROJECT_NAME, (Object)OUTPUT_FILENAME);
    }

    @Override
    public void test() throws Exception {
        super.test();
        IFile expectedResult = ResourcesPlugin.getWorkspace().getRoot().getProject("PC1PC2_result").getFile(OUTPUT_FILENAME);
        IFile currentResult = ResourcesPlugin.getWorkspace().getRoot().getProject(OUTPUT_PROJECT_NAME).getFile(OUTPUT_FILENAME);
        Collection<IDifference> differences = new DiffHelper().setMatchPolicy((IMatchPolicy)new QualifiedMatchPolicy()).getDifferences(currentResult, expectedResult);
        MultiphasesTransitionTest.assertTrue((String)"There shall have no differences between multiphases of 'init_transition' and 'PC1PC2_result'", (boolean)differences.isEmpty());
    }
}

