/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.rules.pa;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.PhysicalPath;
import org.polarsys.capella.core.data.cs.PhysicalPathInvolvement;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.PhysicalPathExt;
import org.polarsys.capella.core.transition.common.constants.Messages;
import org.polarsys.capella.core.transition.common.handlers.log.LogHelper;
import org.polarsys.capella.core.transition.common.handlers.transformation.TransformationHandlerHelper;
import org.polarsys.capella.core.transition.system.rules.AbstractCapellaElementRule;
import org.polarsys.capella.transition.system2subsystem.handlers.attachment.PhysicalPathAttachmentHelper;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class PhysicalPathRule
extends AbstractCapellaElementRule {
    protected EClass getSourceType() {
        return CsPackage.Literals.PHYSICAL_PATH;
    }

    public void apply(EObject element_p, IContext context_p) throws Exception {
        if (this.applyRequired(element_p, context_p).isOK()) {
            PhysicalPath element = (PhysicalPath)element_p;
            PhysicalPathAttachmentHelper.getInstance(context_p).computePath(element, context_p);
        }
        super.apply(element_p, context_p);
    }

    public IStatus transformRequired(EObject element_p, IContext context_p) {
        PhysicalPath element = (PhysicalPath)element_p;
        if (!PhysicalPathExt.isPhysicalPathValid((PhysicalPath)element)) {
            return new Status(2, Messages.Activity_Transformation, NLS.bind((String)"Physical Path ''{0}'' is not valid.", (Object)LogHelper.getInstance().getText((Object)element_p)));
        }
        return Status.OK_STATUS;
    }

    protected void retrieveContainer(EObject element_p, List<EObject> result_p, IContext context_p) {
    }

    protected EObject getDefaultContainer(EObject element_p, EObject result_p, IContext context_p) {
        EObject root = TransformationHandlerHelper.getInstance((IContext)context_p).getLevelElement(element_p, context_p);
        BlockArchitecture target = (BlockArchitecture)TransformationHandlerHelper.getInstance((IContext)context_p).getBestTracedElement(root, context_p, CsPackage.Literals.BLOCK_ARCHITECTURE, element_p, result_p);
        return BlockArchitectureExt.getOrCreateSystem((BlockArchitecture)target);
    }

    protected void retrieveGoDeep(EObject source_p, List<EObject> result_p, IContext context_p) {
        super.retrieveGoDeep(source_p, result_p, context_p);
        PhysicalPath element = (PhysicalPath)source_p;
        if (PhysicalPathExt.isPhysicalPathValid((PhysicalPath)element)) {
            result_p.addAll((Collection<EObject>)element.getOwnedPhysicalPathInvolvements());
            result_p.addAll((Collection<EObject>)element.getOwnedComponentExchangeAllocations());
            for (PhysicalPathInvolvement involvment : element.getOwnedPhysicalPathInvolvements()) {
                result_p.add((EObject)involvment.getInvolvedElement());
            }
        }
    }
}

