/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.tests.multiphases;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.transition.system2subsystem.tests.multiphases.MultiPhasesTest;
import org.polarsys.capella.transition.system2subsystem.tests.util.DiffHelper;

public class OrderedPhysicalComponents
extends MultiPhasesTest {
    public static final String MP_ORDERED_PA_PC_4 = "b271ea03-5360-43a3-823f-1f4aa88f83ba";
    public static final String MP_ORDERED_PA_PC_5 = "3161c9e8-a19f-49eb-98e2-ed3e867a9a08";

    public OrderedPhysicalComponents() {
    }

    public OrderedPhysicalComponents(boolean withLibrary) {
        super(withLibrary);
    }

    @Override
    protected Collection<?> getProjectionElements() {
        return this.getObjects(new String[]{MP_ORDERED_PA_PC_4});
    }

    @Override
    public void test() throws Exception {
        super.test();
        IFile outputModel = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.getOutputModelPlatformURIString()));
        IFile backupOriginal = DiffHelper.copyFile(outputModel);
        this.reorderSourcePCs();
        this.executeTransition();
        Collection<IDifference> differences = new DiffHelper().getDifferences(outputModel, backupOriginal);
        OrderedPhysicalComponents.assertTrue((String)"There shall have no differences when some source component are reordered", (boolean)differences.isEmpty());
    }

    private void reorderSourcePCs() {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.getProject());
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                PhysicalComponent pc4 = (PhysicalComponent)OrderedPhysicalComponents.this.getObject(OrderedPhysicalComponents.MP_ORDERED_PA_PC_4);
                PhysicalComponent pc5 = (PhysicalComponent)OrderedPhysicalComponents.this.getObject(OrderedPhysicalComponents.MP_ORDERED_PA_PC_5);
                EList physicalComponents = ((PhysicalComponent)pc4.eContainer()).getOwnedPhysicalComponents();
                physicalComponents.move(0, (Object)pc4);
                physicalComponents.move(0, (Object)pc5);
            }
        });
    }
}

