/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.tests;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.ctx.SystemComponentPkg;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalComponentPkg;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponentPkg;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.ComponentPkgExt;
import org.polarsys.capella.core.model.helpers.ModelQueryHelper;
import org.polarsys.capella.core.model.helpers.ProjectExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.transition.common.transposer.SharedWorkflowActivityParameter;
import org.polarsys.capella.test.framework.api.BasicCommandTestCase;
import org.polarsys.capella.transition.system2subsystem.tests.TraceabilitySID;
import org.polarsys.kitalpha.cadence.core.api.parameter.GenericParameter;

public abstract class AbstractSystem2SubsystemTest
extends BasicCommandTestCase {
    protected TraceabilitySID traceability;
    private final SharedWorkflowActivityParameter parameters = new SharedWorkflowActivityParameter();
    private Resource outputModelResource;

    private Object getFirstContainer(EObject element, ComponentType type) {
        EObject container = null;
        if (element != null) {
            container = element.eContainer();
        }
        if (container == null) {
            return null;
        }
        if (type.isInstanceOf(container)) {
            return container;
        }
        return this.getFirstContainer(container, type);
    }

    protected void addSharedParameter(String name, Object value) {
        this.getHeadlessParameters().addSharedParameter(new GenericParameter(name, value, name));
    }

    public EObject retrieveReferenceElement(String id) {
        EObject source = this.getObject(id);
        AbstractSystem2SubsystemTest.assertTrue((source != null ? 1 : 0) != 0);
        return source;
    }

    public EObject mustBeTransitionedAndLinkedTo(String id, String id2, EStructuralFeature feature) {
        EObject source = this.retrieveTargetElement(id);
        EObject target = this.retrieveTargetElement(id2);
        this.testReferenceLinked(source, target, feature);
        return source;
    }

    public EObject mustBeTransitionedAndOnlyLinkedTo(String id, Collection<EObject> targetObjectsList, EStructuralFeature feature) {
        EObject source = this.retrieveTargetElement(id);
        EList linkedObjects = (EList)source.eGet(feature);
        AbstractSystem2SubsystemTest.assertTrue((linkedObjects.size() == targetObjectsList.size() && linkedObjects.containsAll(targetObjectsList) ? 1 : 0) != 0);
        return source;
    }

    public EObject mustBeTransitionedAndLinkedTo(String id, EObject target, EStructuralFeature feature) {
        EObject source = this.retrieveTargetElement(id);
        this.testReferenceLinked(source, target, feature);
        return source;
    }

    public EObject mustBeTransitionedAndNotLinkedTo(String id, String id2, EStructuralFeature feature) {
        EObject source = this.retrieveTargetElement(id);
        EObject target = this.traceability.getTracedObject(id2);
        this.testReferenceNotLinked(source, target, feature);
        return source;
    }

    public EObject shouldNotBeTransitioned(String id) {
        EObject source = this.traceability.getTracedObject(id);
        AbstractSystem2SubsystemTest.assertTrue((source == null ? 1 : 0) != 0);
        return source;
    }

    public EObject mustBeTransitioned(String id) {
        EObject source = this.traceability.getTracedObject(id);
        AbstractSystem2SubsystemTest.assertTrue((source != null ? 1 : 0) != 0);
        return source;
    }

    public EObject mustBeTransitioned(String id, ComponentType asType) {
        EObject source = this.traceability.getTracedObject(id);
        AbstractSystem2SubsystemTest.assertTrue((source != null && asType.isInstanceOf(source) ? 1 : 0) != 0);
        return source;
    }

    public EObject mustBeTransitionedInto(String id, ComponentType container_p) {
        boolean is = false;
        for (EObject source : this.traceability.getTracedObjects(id)) {
            AbstractSystem2SubsystemTest.assertTrue((source != null ? 1 : 0) != 0);
            if (this.getFirstContainer(source, container_p) == null) continue;
            is = true;
            break;
        }
        AbstractSystem2SubsystemTest.assertTrue((boolean)is);
        return null;
    }

    public EObject mustBeTransitionedInto(String id, String containerId) {
        EObject source = this.traceability.getTracedObject(id);
        AbstractSystem2SubsystemTest.assertTrue((source != null ? 1 : 0) != 0);
        EObject container = this.traceability.getTracedObject(containerId);
        AbstractSystem2SubsystemTest.assertTrue((container != null ? 1 : 0) != 0);
        AbstractSystem2SubsystemTest.assertEquals((Object)source.eContainer(), (Object)container);
        return source;
    }

    public EObject shouldNotBeTransitionedInto(String id, ComponentType container_p) {
        for (EObject source : this.traceability.getTracedObjects(id)) {
            AbstractSystem2SubsystemTest.assertTrue((source != null ? 1 : 0) != 0);
            if (this.getFirstContainer(source, container_p) == null) continue;
            AbstractSystem2SubsystemTest.assertFalse((boolean)true);
            break;
        }
        return null;
    }

    public EObject mustBeTransitionedOutside(String id, ComponentType container) {
        EObject source = this.traceability.getTracedObject(id);
        AbstractSystem2SubsystemTest.assertTrue((source != null ? 1 : 0) != 0);
        AbstractSystem2SubsystemTest.assertTrue((this.getFirstContainer(source, container) == null ? 1 : 0) != 0);
        return source;
    }

    public EObject mustBeTransitionedOnce(String id) {
        Collection<EObject> sources = this.traceability.getTracedObjects(id);
        AbstractSystem2SubsystemTest.assertTrue((sources != null && sources.size() == 1 ? 1 : 0) != 0);
        return null;
    }

    public EObject retrieveTargetElement(String id) {
        EObject source = this.traceability.getTracedObject(id);
        AbstractSystem2SubsystemTest.assertTrue((source != null ? 1 : 0) != 0);
        return source;
    }

    public Component retrieveTargetSystem() {
        ModelElement dummyTargetElement = (ModelElement)this.getOutputModelResource().getContents().get(0);
        Project targetProject = ProjectExt.getProject((EObject)dummyTargetElement);
        SystemEngineering targetSystemEngineering = SystemEngineeringExt.getSystemEngineering((Project)targetProject);
        Component targetSystem = SystemEngineeringExt.getSystem((SystemEngineering)targetSystemEngineering);
        AbstractSystem2SubsystemTest.assertTrue((targetSystem != null ? 1 : 0) != 0);
        return targetSystem;
    }

    public LogicalComponent retrieveTargetLogicalSystem() {
        ModelElement dummyTargetElement = (ModelElement)this.getOutputModelResource().getContents().get(0);
        Project targetProject = ProjectExt.getProject((EObject)dummyTargetElement);
        LogicalComponent targetLogicalSystem = ModelQueryHelper.getLogicalSystem((Project)targetProject);
        AbstractSystem2SubsystemTest.assertTrue((targetLogicalSystem != null ? 1 : 0) != 0);
        return targetLogicalSystem;
    }

    public void testReferenceLinked(EObject source, EObject target, EStructuralFeature feature) {
        if (feature.isMany()) {
            AbstractSystem2SubsystemTest.assertTrue((boolean)((List)source.eGet(feature)).contains(target));
        } else {
            AbstractSystem2SubsystemTest.assertTrue((boolean)source.eGet(feature).equals(target));
        }
    }

    public void testReferenceNotLinked(EObject source, EObject target, EStructuralFeature feature) {
        if (target == null) {
            if (feature.isMany()) {
                AbstractSystem2SubsystemTest.assertTrue((source.eGet(feature) == null || !((List)source.eGet(feature)).contains(null) ? 1 : 0) != 0);
            } else {
                AbstractSystem2SubsystemTest.assertTrue((source.eGet(feature) == null ? 1 : 0) != 0);
            }
        } else if (feature.isMany()) {
            AbstractSystem2SubsystemTest.assertTrue((!source.eGet(feature).equals(target) && !((List)source.eGet(feature)).contains(target) ? 1 : 0) != 0);
        } else {
            AbstractSystem2SubsystemTest.assertTrue((!source.eGet(feature).equals(target) ? 1 : 0) != 0);
        }
    }

    public void testAttributeIdentity(EObject source, EObject target, EAttribute attribute) {
        Object targetValue;
        Object sourceValue = source.eGet((EStructuralFeature)attribute);
        AbstractSystem2SubsystemTest.assertTrue((sourceValue == (targetValue = target.eGet((EStructuralFeature)attribute)) || sourceValue != null && sourceValue.equals(targetValue) ? 1 : 0) != 0);
    }

    public void testInstanceOf(EObject source, ComponentType clazz) {
        AbstractSystem2SubsystemTest.assertTrue((boolean)clazz.isInstanceOf(source));
    }

    protected SharedWorkflowActivityParameter getHeadlessParameters() {
        return this.parameters;
    }

    protected String getOutputModelPlatformURIString() {
        return "/output/output.melodymodeller";
    }

    protected Resource getOutputModelResource() {
        if (this.outputModelResource == null) {
            ResourceSet set = new ExecutionManager().getEditingDomain().getResourceSet();
            this.outputModelResource = set.getResource(URI.createPlatformResourceURI((String)this.getOutputModelPlatformURIString(), (boolean)true), true);
        }
        return this.outputModelResource;
    }

    protected final TraceabilitySID initTraceability(Resource modelResource, Resource outputModelResource) {
        TraceabilitySID result = this.createTraceability();
        result.init(modelResource, outputModelResource);
        return result;
    }

    protected TraceabilitySID createTraceability() {
        return new TraceabilitySID();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.getHeadlessParameters().addSharedParameter(new GenericParameter("outputModel", (Object)this.getOutputModelPlatformURIString(), "The output model path"));
    }

    public static enum ComponentType {
        SYSTEM,
        ACTOR,
        SYSTEM_ANALYSIS,
        SYSTEM_STRUCTURE,
        LOGICAL_ARCHITECTURE,
        LOGICAL_STRUCTURE,
        LOGICAL_COMPONENT,
        LOGICAL_ACTOR,
        PHYSICAL_ARCHITECTURE,
        PHYSICAL_STRUCTURE,
        PHYSICAL_ACTOR;


        public boolean isInstanceOf(EObject source) {
            switch (this) {
                case ACTOR: {
                    return ComponentExt.isActor((EObject)source);
                }
                case SYSTEM: {
                    return source instanceof Component && BlockArchitectureExt.isRootComponent((Component)((Component)source));
                }
                case SYSTEM_ANALYSIS: {
                    return source instanceof SystemAnalysis;
                }
                case SYSTEM_STRUCTURE: {
                    return source instanceof SystemComponentPkg && ComponentPkgExt.isRootComponentPkg((EObject)source);
                }
                case LOGICAL_ARCHITECTURE: {
                    return source instanceof LogicalArchitecture;
                }
                case LOGICAL_STRUCTURE: {
                    return source instanceof LogicalComponentPkg && ComponentPkgExt.isRootComponentPkg((EObject)source);
                }
                case LOGICAL_COMPONENT: {
                    return !ComponentExt.isActor((EObject)source) && BlockArchitectureExt.getRootBlockArchitecture((EObject)source) instanceof LogicalArchitecture;
                }
                case LOGICAL_ACTOR: {
                    return ComponentExt.isActor((EObject)source) && BlockArchitectureExt.getRootBlockArchitecture((EObject)source) instanceof LogicalArchitecture;
                }
                case PHYSICAL_ARCHITECTURE: {
                    return source instanceof PhysicalArchitecture;
                }
                case PHYSICAL_STRUCTURE: {
                    return source instanceof PhysicalComponentPkg && ComponentPkgExt.isRootComponentPkg((EObject)source);
                }
                case PHYSICAL_ACTOR: {
                    return ComponentExt.isActor((EObject)source) && BlockArchitectureExt.getRootBlockArchitecture((EObject)source) instanceof PhysicalArchitecture;
                }
            }
            return false;
        }
    }
}

