/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.handlers.attachment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementFunction;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementLink;
import org.polarsys.capella.core.data.fa.FunctionalChainReference;
import org.polarsys.capella.core.model.helpers.graph.InvolvementHierarchyGraph;

public class InvolvementHierarchyGraph2
extends InvolvementHierarchyGraph {
    public InvolvementHierarchyGraph2(FunctionalChain rootFunctionalChain) {
        super(rootFunctionalChain);
    }

    public Collection<Vertex> getVertexs(FunctionalChainInvolvement fci) {
        return this.vertices.keySet().stream().filter(v -> ((VertexKey)((Object)v)).getFunction() == fci).map(v -> (InvolvementHierarchyGraph.Vertex)this.vertices.get(v)).collect(Collectors.toList());
    }

    protected boolean createVertex(FunctionalChainInvolvementFunction function, List<FunctionalChainReference> referenceHierarchy) {
        ArrayList<FunctionalChainReference> functionHierarchy = new ArrayList<FunctionalChainReference>(referenceHierarchy);
        VertexKey vertexKey = new VertexKey(function, functionHierarchy);
        if (this.vertices.containsKey((Object)vertexKey)) {
            return false;
        }
        Vertex vertex = new Vertex(function, functionHierarchy);
        this.vertices.put(vertexKey, vertex);
        return true;
    }

    protected void createEdge(FunctionalChainInvolvementLink link, InvolvementHierarchyGraph.Vertex sourceVertex, InvolvementHierarchyGraph.Vertex targetVertex) {
        Edge edge = new Edge(link, (Vertex)sourceVertex, (Vertex)targetVertex);
        ((Vertex)sourceVertex).getEdges().add(edge);
        ((Vertex)targetVertex).getIncomings().add(edge);
    }

    protected Vertex getVertex(FunctionalChainInvolvementFunction function, List<FunctionalChainReference> functionReferenceHierarchy) {
        VertexKey vertexKey = new VertexKey(function, functionReferenceHierarchy);
        return (Vertex)this.vertices.get((Object)vertexKey);
    }

    public class Edge
    extends InvolvementHierarchyGraph.Edge
    implements Element {
        public Edge(FunctionalChainInvolvementLink link, Vertex source, Vertex target) {
            super(link, (InvolvementHierarchyGraph.Vertex)source, (InvolvementHierarchyGraph.Vertex)target);
        }

        @Override
        public FunctionalChainInvolvement getElement() {
            return this.link;
        }

        public FunctionalChainInvolvementLink getLink() {
            return this.link;
        }

        public Vertex getSource() {
            return (Vertex)this.source;
        }

        public Vertex getTarget() {
            return (Vertex)this.target;
        }

        @Override
        public List<Element> getNexts() {
            return Arrays.asList(this.getTarget());
        }

        @Override
        public List<Element> getPrevious() {
            return Arrays.asList(this.getSource());
        }
    }

    public static interface Element {
        public List<Element> getNexts();

        public List<Element> getPrevious();

        public FunctionalChainInvolvement getElement();
    }

    public class Vertex
    extends InvolvementHierarchyGraph.Vertex
    implements Element {
        protected List<Edge> incomings;

        public Vertex(FunctionalChainInvolvementFunction function, List<FunctionalChainReference> referenceHierarchy) {
            super(function, referenceHierarchy);
            this.incomings = new ArrayList<Edge>();
        }

        public FunctionalChainInvolvementFunction getFunction() {
            return this.function;
        }

        @Override
        public FunctionalChainInvolvement getElement() {
            return this.function;
        }

        public List<Edge> getEdges() {
            return this.edges;
        }

        public List<Edge> getIncomings() {
            return this.incomings;
        }

        @Override
        public List<Element> getNexts() {
            return this.getEdges();
        }

        @Override
        public List<Element> getPrevious() {
            return this.getIncomings();
        }
    }

    public class VertexKey
    extends InvolvementHierarchyGraph.VertexKey {
        public VertexKey(FunctionalChainInvolvementFunction function, List<FunctionalChainReference> referenceHierarchy) {
            super(function, referenceHierarchy);
        }

        public FunctionalChainInvolvementFunction getFunction() {
            return this.function;
        }
    }
}

