/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.handlers.attachment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementFunction;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementLink;
import org.polarsys.capella.core.data.fa.FunctionalChainReference;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.fa.SequenceLink;
import org.polarsys.capella.core.data.fa.SequenceLinkEnd;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.FunctionalChainExt;
import org.polarsys.capella.core.transition.common.handlers.IHandler;
import org.polarsys.capella.core.transition.common.handlers.contextscope.ContextScopeHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.contextscope.IContextScopeHandler;
import org.polarsys.capella.core.transition.common.handlers.notify.INotifyChangeEvent;
import org.polarsys.capella.core.transition.common.handlers.notify.INotifyListener;
import org.polarsys.capella.core.transition.common.handlers.notify.NotifyHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.scope.ScopeHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.transformation.TransformationHandlerHelper;
import org.polarsys.capella.transition.system2subsystem.handlers.attachment.GraphHelper;
import org.polarsys.capella.transition.system2subsystem.handlers.attachment.InvolvementHierarchyGraph2;
import org.polarsys.capella.transition.system2subsystem.handlers.attachment.SubSets;
import org.polarsys.capella.transition.system2subsystem.handlers.scope.ExternalFunctionsScopeRetriever;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class FunctionalChainAttachmentHelper
implements IHandler,
INotifyListener {
    protected static final String FUNCTIONAL_CHAIN_ATTACHMENT_MAP = "FCAttachmentMap";
    protected static final String MERGE_MAP = "MERGE_MAP";
    protected static final String IS_COMPUTED = "FunctionalChainAttachmentHelper.IS_COMPUTED";
    protected static final String GRAPH_MAPS = "FunctionalChainAttachmentHelper.GraphMap";

    public static FunctionalChainAttachmentHelper getInstance(IContext context_p) {
        FunctionalChainAttachmentHelper handler = (FunctionalChainAttachmentHelper)context_p.get((Object)"FCAttachment");
        if (handler == null) {
            handler = new FunctionalChainAttachmentHelper();
            handler.init(context_p);
            context_p.put((Object)"FCAttachment", (Object)handler);
        }
        return handler;
    }

    public HashMap<FunctionalChain, InvolvementHierarchyGraph2> getGraphs(IContext context_p) {
        HashMap graphs = (HashMap)context_p.get((Object)GRAPH_MAPS);
        if (graphs == null) {
            graphs = new HashMap();
            context_p.put((Object)GRAPH_MAPS, graphs);
        }
        return graphs;
    }

    public InvolvementHierarchyGraph2 getGraph(FunctionalChain chain, IContext context_p) {
        HashMap<FunctionalChain, InvolvementHierarchyGraph2> graphs = this.getGraphs(context_p);
        if (!graphs.containsKey(chain)) {
            graphs.put(chain, new InvolvementHierarchyGraph2(chain));
        }
        return graphs.get(chain);
    }

    public Boolean isValidElement(FunctionalChainInvolvement source, IContext context_p) {
        this.computeChains((FunctionalChain)source.eContainer(), context_p);
        Boolean cache = this.getValidityMap(context_p).get(source);
        if (cache == null) {
            cache = Boolean.FALSE;
        }
        return cache;
    }

    public void setValidElement(EObject source, Boolean target, IContext context_p) {
        this.getValidityMap(context_p).put(source, target);
    }

    protected SubSets<FunctionalChainInvolvementFunction> getMergeSets(IContext context_p) {
        SubSets res = (SubSets)context_p.get((Object)MERGE_MAP);
        if (res == null) {
            res = new SubSets();
            context_p.put((Object)MERGE_MAP, res);
        }
        return res;
    }

    protected Map<EObject, Boolean> getValidityMap(IContext context_p) {
        HashMap res = (HashMap)context_p.get((Object)FUNCTIONAL_CHAIN_ATTACHMENT_MAP);
        if (res == null) {
            res = new HashMap();
            context_p.put((Object)FUNCTIONAL_CHAIN_ATTACHMENT_MAP, res);
        }
        return res;
    }

    public IStatus init(IContext context_p) {
        NotifyHandlerHelper.getInstance((IContext)context_p).addListener("NOTIFY__END_TRANSFORMATION", (INotifyListener)this, context_p);
        return Status.OK_STATUS;
    }

    public IStatus dispose(IContext context_p) {
        return Status.OK_STATUS;
    }

    public void computeChainNodes(FunctionalChain element_p, IContext context_p) {
        IContextScopeHandler scope = ContextScopeHandlerHelper.getInstance((IContext)context_p);
        Collection allInvolvements = FunctionalChainExt.getFlatInvolvements((FunctionalChain)element_p);
        for (FunctionalChainInvolvement involvment : allInvolvements) {
            boolean inScope;
            InvolvedElement involvedElement;
            if (this.isAlreadyCached(involvment, context_p) || (involvedElement = involvment.getInvolved()) instanceof FunctionalExchange) continue;
            IStatus willBeTransformed = TransformationHandlerHelper.getInstance((IContext)context_p).isOrWillBeTransformed((EObject)involvedElement, context_p);
            if (!willBeTransformed.isOK()) {
                this.setValidElement((EObject)involvment, false, context_p);
                continue;
            }
            if (involvedElement instanceof AbstractFunction) {
                inScope = ExternalFunctionsScopeRetriever.isPrimaryFunction((AbstractFunction)involvedElement, context_p) || ExternalFunctionsScopeRetriever.isLinkToPrimaryFunction((AbstractFunction)involvedElement, context_p);
                this.setValidElement((EObject)involvment, inScope, context_p);
                continue;
            }
            if (!(involvedElement instanceof FunctionalChain)) continue;
            inScope = !scope.contains("scope_secondary_element", (EObject)involvedElement, context_p) && ScopeHandlerHelper.getInstance((IContext)context_p).isInScope((EObject)involvedElement, context_p);
            this.setValidElement((EObject)involvment, inScope, context_p);
        }
    }

    public void computeChainLinks(FunctionalChain element_p, IContext context_p) {
        Set allInvolvements = FunctionalChainExt.getFlatInvolvementsOf((FunctionalChain)element_p, (EClass)FaPackage.Literals.FUNCTIONAL_EXCHANGE);
        for (FunctionalChainInvolvement involvment : allInvolvements) {
            if (this.isAlreadyCached(involvment, context_p)) continue;
            FunctionalExchange exchange = (FunctionalExchange)involvment.getInvolved();
            IStatus willBeTransformed = TransformationHandlerHelper.getInstance((IContext)context_p).isOrWillBeTransformed((EObject)exchange, context_p);
            if (!willBeTransformed.isOK()) {
                this.setValidElement((EObject)involvment, false, context_p);
                continue;
            }
            if (involvment.getNextFunctionalChainInvolvements().isEmpty()) {
                this.setValidElement((EObject)involvment, false, context_p);
                continue;
            }
            boolean prevScoped = false;
            boolean nextScoped = false;
            for (FunctionalChainInvolvement n : involvment.getNextFunctionalChainInvolvements()) {
                if (!this.getValidityMap(context_p).get(n).booleanValue()) continue;
                nextScoped = true;
                break;
            }
            for (FunctionalChainInvolvement p : involvment.getPreviousFunctionalChainInvolvements()) {
                if (!this.getValidityMap(context_p).get(p).booleanValue()) continue;
                prevScoped = true;
                break;
            }
            this.setValidElement((EObject)involvment, prevScoped && nextScoped, context_p);
        }
    }

    public Collection<FunctionalChainInvolvement> getNextValid(FunctionalChainInvolvement fci, IContext context) {
        this.computeChains((FunctionalChain)fci.eContainer(), context);
        if (fci instanceof FunctionalChainInvolvementLink) {
            FunctionalChainInvolvementFunction target = ((FunctionalChainInvolvementLink)fci).getTarget();
            if (this.isValidElement((FunctionalChainInvolvement)target, context).booleanValue()) {
                return Arrays.asList(target);
            }
            return this.getNextValid((FunctionalChainInvolvement)target, context);
        }
        if (fci instanceof FunctionalChainReference) {
            return Collections.emptyList();
        }
        LinkedHashSet<FunctionalChainInvolvement> lasts = new LinkedHashSet<FunctionalChainInvolvement>();
        for (LinkedList<FunctionalChainInvolvement> list : this.getNextPathsTowards(fci, null, context)) {
            if (list.getLast() == null || list.getLast() == fci) continue;
            lasts.add(list.getLast());
        }
        return lasts;
    }

    public Collection<FunctionalChainInvolvement> getPreviousValid(FunctionalChainInvolvement fci, IContext context) {
        this.computeChains((FunctionalChain)fci.eContainer(), context);
        if (fci instanceof FunctionalChainInvolvementLink) {
            FunctionalChainInvolvementFunction source = ((FunctionalChainInvolvementLink)fci).getSource();
            if (this.isValidElement((FunctionalChainInvolvement)source, context).booleanValue()) {
                return Arrays.asList(source);
            }
            return this.getPreviousValid((FunctionalChainInvolvement)source, context);
        }
        if (fci instanceof FunctionalChainReference) {
            return Collections.emptyList();
        }
        LinkedHashSet<FunctionalChainInvolvement> lasts = new LinkedHashSet<FunctionalChainInvolvement>();
        for (LinkedList<FunctionalChainInvolvement> list : this.getPreviousPathsTowards(fci, null, context)) {
            if (list.getLast() == null || list.getLast() == fci) continue;
            lasts.add(list.getLast());
        }
        return lasts;
    }

    public static Collection<LinkedList<FunctionalChainInvolvement>> toFCI(Collection<LinkedList<InvolvementHierarchyGraph2.Element>> elements) {
        return elements.stream().map(c -> FunctionalChainAttachmentHelper.toFCI(c)).collect(Collectors.toList());
    }

    public static LinkedList<FunctionalChainInvolvement> toFCI(LinkedList<InvolvementHierarchyGraph2.Element> elements) {
        return elements.stream().map(d -> d.getElement()).collect(Collectors.toCollection(LinkedList::new));
    }

    public Collection<LinkedList<FunctionalChainInvolvement>> getNextPathsTowards(FunctionalChainInvolvement fci, FunctionalChainInvolvement expected, IContext context) {
        this.computeChains((FunctionalChain)fci.eContainer(), context);
        ArrayList<LinkedList<FunctionalChainInvolvement>> allPaths = new ArrayList<LinkedList<FunctionalChainInvolvement>>();
        for (InvolvementHierarchyGraph2 g : this.getGraphs(context).values()) {
            for (InvolvementHierarchyGraph2.Vertex v : g.getVertexs(fci)) {
                allPaths.addAll(FunctionalChainAttachmentHelper.toFCI(GraphHelper.getPathsTowards(v, n -> this.isTheOne((InvolvementHierarchyGraph2.Element)n, expected, context), context, n -> n.getNexts())));
            }
        }
        return allPaths;
    }

    public Collection<LinkedList<FunctionalChainInvolvement>> getPreviousPathsTowards(FunctionalChainInvolvement fci, FunctionalChainInvolvement expected, IContext context) {
        this.computeChains((FunctionalChain)fci.eContainer(), context);
        ArrayList<LinkedList<FunctionalChainInvolvement>> allPaths = new ArrayList<LinkedList<FunctionalChainInvolvement>>();
        for (InvolvementHierarchyGraph2 g : this.getGraphs(context).values()) {
            for (InvolvementHierarchyGraph2.Vertex v : g.getVertexs(fci)) {
                allPaths.addAll(FunctionalChainAttachmentHelper.toFCI(GraphHelper.getPathsTowards(v, n -> this.isTheOne((InvolvementHierarchyGraph2.Element)n, expected, context), context, n -> n.getPrevious())));
            }
        }
        return allPaths;
    }

    public boolean isTheOne(InvolvementHierarchyGraph2.Element current, FunctionalChainInvolvement expected, IContext context) {
        return expected == null && this.isValidElement(current.getElement(), context) != false || current.getElement().equals(expected);
    }

    public void merge(FunctionalChainInvolvementFunction tSrc, FunctionalChainInvolvementFunction tTgt, IContext context) {
        this.getMergeSets(context).merge(tSrc, tTgt);
    }

    public void notifyChanged(INotifyChangeEvent event, IContext context) {
        for (Collection collection : this.getMergeSets(context).getSets()) {
            FunctionalChainInvolvementFunction[] array = collection.toArray(new FunctionalChainInvolvementFunction[0]);
            int i = 1;
            while (i < array.length) {
                for (EObject o : EObjectExt.getReferencers((EObject)array[i], (EReference)FaPackage.Literals.FUNCTIONAL_CHAIN_INVOLVEMENT_LINK__SOURCE)) {
                    ((FunctionalChainInvolvementLink)o).setSource(array[0]);
                }
                for (EObject o : EObjectExt.getReferencers((EObject)array[i], (EReference)FaPackage.Literals.FUNCTIONAL_CHAIN_INVOLVEMENT_LINK__TARGET)) {
                    ((FunctionalChainInvolvementLink)o).setTarget(array[0]);
                }
                for (EObject o : EObjectExt.getReferencers((EObject)array[i], (EReference)FaPackage.Literals.SEQUENCE_LINK__SOURCE)) {
                    ((SequenceLink)o).setSource((SequenceLinkEnd)array[0]);
                }
                for (EObject o : EObjectExt.getReferencers((EObject)array[i], (EReference)FaPackage.Literals.SEQUENCE_LINK__TARGET)) {
                    ((SequenceLink)o).setTarget((SequenceLinkEnd)array[0]);
                }
                ++i;
            }
        }
    }

    protected boolean isAlreadyCached(FunctionalChainInvolvement fci, IContext context) {
        return this.getValidityMap(context).get(fci) != null;
    }

    protected Collection<FunctionalChain> getChainsToAnalyse(FunctionalChain element, IContext context_p) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)element);
        return FunctionalChainExt.getAllFunctionalChains((BlockArchitecture)architecture).stream().filter(fc -> ScopeHandlerHelper.getInstance((IContext)context_p).isInScope((EObject)fc, context_p)).filter(FunctionalChainExt::isFunctionalChainValid).collect(Collectors.toList());
    }

    public void computeChains(FunctionalChain element, IContext context_p) {
        if (context_p.get((Object)IS_COMPUTED) == null) {
            Collection<FunctionalChain> validChainsInScope = this.getChainsToAnalyse(element, context_p);
            for (FunctionalChain chain : validChainsInScope) {
                this.getGraph(chain, context_p);
            }
            for (FunctionalChain chain : validChainsInScope) {
                this.computeChainNodes(chain, context_p);
            }
            for (FunctionalChain chain : validChainsInScope) {
                this.computeChainLinks(chain, context_p);
            }
            context_p.put((Object)IS_COMPUTED, (Object)Boolean.TRUE);
        }
    }
}

