/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.tests.ju.tests.misc;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.polarsys.capella.filtering.tools.helpers.ViewpointHelper;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.helpers.GuiActions;
import org.polarsys.capella.test.framework.helpers.IResourceHelpers;
import org.polarsys.capella.test.migration.ju.helpers.MigrationHelper;

public class ActivatedFilterMigrationTest
extends BasicTestCase {
    private static final String FILTER_TO_REMOVE_NAME = "VisibleDiagramFilteringCriteria";
    private static final List<String> MODELS_WITH_VIEWPOINT_ACTIVATED = Arrays.asList("library-viewpoint-activated", "model-viewpoint-activated");
    private static final List<String> MODELS_WITH_VIEWPOINT_DEACTIVATED = Arrays.asList("library-viewpoint-deactivated", "model-viewpoint-deactivated");

    public void test() throws Exception {
        this.assertValidModelMigration(MODELS_WITH_VIEWPOINT_ACTIVATED, true);
        this.assertValidModelMigration(MODELS_WITH_VIEWPOINT_DEACTIVATED, false);
    }

    protected void assertValidModelMigration(List<String> modelNames, boolean viewpointWasActivated) {
        for (String modelName : modelNames) {
            IProject project = IResourceHelpers.getEclipseProjectInWorkspace((String)modelName);
            MigrationHelper.migrateProject((IProject)project);
            Session session = this.getSessionForTestModel(modelName);
            ActivatedFilterMigrationTest.assertNotNull((Object)session);
            List diagrams = DialectManager.INSTANCE.getAllRepresentations(session).stream().filter(DSemanticDiagram.class::isInstance).map(DSemanticDiagram.class::cast).collect(Collectors.toList());
            ActivatedFilterMigrationTest.assertFalse((boolean)diagrams.isEmpty());
            ActivatedFilterMigrationTest.assertEquals((boolean)viewpointWasActivated, (boolean)ViewpointHelper.isViewpointActive((EObject)((EObject)diagrams.get(0))));
            for (DSemanticDiagram diagram : diagrams) {
                Optional<FilterDescription> visibleFilter = diagram.getActivatedFilters().stream().filter(f -> FILTER_TO_REMOVE_NAME.equals(f.getName())).findAny();
                ActivatedFilterMigrationTest.assertEquals((boolean)visibleFilter.isPresent(), (boolean)viewpointWasActivated);
            }
            GuiActions.closeSession((Session)session);
        }
    }

    public List<String> getRequiredTestModels() {
        return Stream.concat(MODELS_WITH_VIEWPOINT_ACTIVATED.stream(), MODELS_WITH_VIEWPOINT_DEACTIVATED.stream()).collect(Collectors.toList());
    }
}

