/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.tests.ju.tests.misc;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.model.helpers.ProjectExt;
import org.polarsys.capella.filtering.tools.utils.FilteringUtils;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.helpers.TestHelper;

public class DirtyReferencedModelsTest
extends BasicTestCase {
    public static final String PROJECT_NAME = "simple-project";
    public static final String ROOT_LIBRARY_NAME = "simple-library";
    public static final String CHILD_LIBRARY_NAME = "simple-library-child";

    public void test() throws Exception {
        Session projectSession = this.getSessionForTestModel(PROJECT_NAME);
        DirtyReferencedModelsTest.assertNotNull((Object)projectSession);
        Session rootLibrarySession = this.getSessionForTestModel(ROOT_LIBRARY_NAME);
        DirtyReferencedModelsTest.assertNotNull((Object)rootLibrarySession);
        Session childLibrarySession = this.getSessionForTestModel(CHILD_LIBRARY_NAME);
        DirtyReferencedModelsTest.assertNotNull((Object)childLibrarySession);
        Resource projectResource = TestHelper.getSemanticResource((Session)projectSession);
        Project project = ProjectExt.getProject((Resource)projectResource);
        DirtyReferencedModelsTest.assertNotNull((Object)project);
        Map dirtyReferencedModels = FilteringUtils.getDirtyReferencedModels((Project)project);
        DirtyReferencedModelsTest.assertTrue((boolean)dirtyReferencedModels.isEmpty());
        this.setSessionDirty(projectSession);
        dirtyReferencedModels = FilteringUtils.getDirtyReferencedModels((Project)project);
        DirtyReferencedModelsTest.assertEquals((int)1, (int)dirtyReferencedModels.size());
        DirtyReferencedModelsTest.assertTrue((boolean)dirtyReferencedModels.containsValue(projectSession));
        this.setSessionDirty(rootLibrarySession);
        dirtyReferencedModels = FilteringUtils.getDirtyReferencedModels((Project)project);
        DirtyReferencedModelsTest.assertEquals((int)2, (int)dirtyReferencedModels.size());
        DirtyReferencedModelsTest.assertTrue((boolean)dirtyReferencedModels.containsValue(projectSession));
        DirtyReferencedModelsTest.assertTrue((boolean)dirtyReferencedModels.containsValue(rootLibrarySession));
        this.setSessionDirty(childLibrarySession);
        dirtyReferencedModels = FilteringUtils.getDirtyReferencedModels((Project)project);
        DirtyReferencedModelsTest.assertEquals((int)3, (int)dirtyReferencedModels.size());
        DirtyReferencedModelsTest.assertTrue((boolean)dirtyReferencedModels.containsValue(projectSession));
        DirtyReferencedModelsTest.assertTrue((boolean)dirtyReferencedModels.containsValue(rootLibrarySession));
        DirtyReferencedModelsTest.assertTrue((boolean)dirtyReferencedModels.containsValue(childLibrarySession));
    }

    private void setSessionDirty(Session session) {
        final Resource resource = session.getSessionResource();
        TransactionHelper.getExecutionManager((Session)session).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                EList resourceContents = resource.getContents();
                int lastElementIndex = resourceContents.size() - 1;
                EObject lastElement = (EObject)resourceContents.remove(lastElementIndex);
                resourceContents.add(lastElementIndex, (Object)lastElement);
            }
        });
    }

    public List<String> getRequiredTestModels() {
        return Arrays.asList(PROJECT_NAME, ROOT_LIBRARY_NAME, CHILD_LIBRARY_NAME);
    }
}

