/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.tools.decorators;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.sirius.ui.business.api.descriptor.ComposedImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.polarsys.capella.filtering.tools.FilteringToolsPlugin;
import org.polarsys.capella.filtering.tools.helpers.ViewpointHelper;
import org.polarsys.capella.filtering.tools.utils.FilteringUtils;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

public class CriteriaLabelDecorator
implements ILabelDecorator {
    public static final ImageDescriptor FILTERING_OVERLAY_DESC = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.polarsys.capella.filtering.tools", (String)"icons/ovr_optional.png");

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image decorateImage(Image image, Object element) {
        if (!(element instanceof ExtensibleElement) || !ViewpointHelper.isViewpointActive((EObject)((ExtensibleElement)element)) || image == null) {
            return null;
        }
        if (this.isOptional((ExtensibleElement)element)) {
            ComposedImage img = this.decorateFiltering(image);
            ComposedImageDescriptor descriptor = new ComposedImageDescriptor(img);
            return FilteringToolsPlugin.getDefault().getImage((ImageDescriptor)descriptor);
        }
        return null;
    }

    private ComposedImage decorateFiltering(Image image) {
        ArrayList<Image> images = new ArrayList<Image>(2);
        images.add(image);
        images.add(FilteringToolsPlugin.getDefault().getImage(FILTERING_OVERLAY_DESC));
        return new ComposedImage(images){

            public List<ComposedImage.Point> getDrawPoints(ComposedImage.Size size) {
                ArrayList<ComposedImage.Point> results = new ArrayList<ComposedImage.Point>();
                results.add(new ComposedImage.Point());
                ComposedImage.Point overlay = new ComposedImage.Point();
                overlay.x = 0;
                overlay.y = 7;
                results.add(overlay);
                return results;
            }
        };
    }

    public String decorateText(String text, Object element) {
        String decorator;
        if (element instanceof ExtensibleElement && ViewpointHelper.isViewpointActive((EObject)((ExtensibleElement)element)) && this.isOptional((ExtensibleElement)element) && (decorator = FilteringUtils.getCommaSeparatedExplicitFeatures((EObject)((ExtensibleElement)element))) != null) {
            return String.valueOf(text) + " [" + decorator + "]";
        }
        return text;
    }

    private boolean isOptional(ExtensibleElement element) {
        return !FilteringUtils.getExplicitAssociatedCriteria((EObject)element).isEmpty();
    }
}

